#ifndef ___BUILCULE_DRAW_H
#define ___BUILCULE_DRAW_H

#include "widget_draw_base.h"
#include <builcule/lb2/builcule_unit.h>

class Builcule_Draw : public Widget_Draw_Base {
 private:
  //編集されてアドレスが変わる可能性あるので，*AtomVectにしない
  //領域の回転もおこなうので，*Unit ではなく *Builcule_Unit
  Builcule_Unit *UnitPtr;

  //内部オブジェクト
  std::vector<Sphere> SphereVect;
  std::vector<Cylinder> CylinderVect;
  std::vector<Wire> WireVect;

  std::map<int, int> SerialToSphereIdx;  //ピックの照合用
  std::vector<int> PickedSerial;

  Affine_Trans AffineTrans;

  //描画オブジェクトの作成用
  void set_sphere_radius_ball(int idx);
  void set_sphere_radius_spacefill(int idx);
  void set_sphere_color_cpk(int idx);
  void set_sphere_color_pick(int idx);

  void paintGL();

  void draw_sphere();
  void draw_cylinder();
  void draw_wire();

  //イベントハンドラ．final キーワードは備忘メモ
  void mousePressEvent(QMouseEvent *event) final;
  void mouseMoveEvent(QMouseEvent *event) final;
  void mouseReleaseEvent(QMouseEvent *event) final;
  void wheelEvent(QWheelEvent *event) final;

  void move_eye(int x0, int y0);
  void rotate_unit(int x0, int y0);
  void rotate_mol(int x0, int y0);
  void move_mol(int x0, int y0);
  void rotate_region(int x0);
  void move_region(int x0);
  bool obj_empty();  //関数の番兵として使う
  int pick();
  void delete_picked_serial(int serial);  //ピックをピックして削除

 public:
  Builcule_Draw(QWidget *parent = nullptr);
  void set_unit(Builcule_Unit *unit) { UnitPtr = unit; }

  //バックアップとリストア用
  const Eigen::Vector3d *get_draw_center() const
        { return &DrawCenter; }
  void set_draw_center(const Eigen::Vector3d *center)
        { DrawCenter = *center; }

  double get_draw_radius() const { return DrawRadius; }
  void set_draw_radius(double radius) { DrawRadius = radius; }

  const Eigen::Vector3d *get_eye_pos() const
        { return &EyePos; }
  void set_eye_pos(const Eigen::Vector3d *pos) { EyePos = *pos; }

  //描画オブジェクト
  void clear_obj();
  void clear_picked_obj();
  void push_wire();
  void push_cylinder();
  void push_sphere();
  void set_sphere_radius(Draw_Model model);
  void push_checked_sphere();
  void set_checked_sphere_radius();
  void set_checked_sphere_radius(Draw_Model model);
  void push_checked_cylinder();

  //描画の調整
  void calc_eye_pos(const Eigen::Vector3d *center, double radius);
  void set_affine_trans(Affine_Trans affine)
        { AffineTrans = affine; }

  double measure_distance();
  double measure_angle();
  double measure_diheadral();

  void change_elmt(int elmt);

  const std::vector<int> *get_picked_serial() const
        { return &PickedSerial; }
  int get_mol_idx(int serial) const;
  int get_pept_idx(int serial) const;
  int get_seq_idx(int serial) const;
};

#endif
