#include "builcule_main.h"
#include <builcule/lb2/create_bone.h>

int Builcule_Main::get_curt_unit() {
 for(int i = 0; i < 3; ++i) {
  if(BDraw[i].isVisible())
   return i;
 }
 return -1;
}

void Builcule_Main::slot_unit_changed() {
 int curt_unit = get_curt_unit();
 int next_unit = GroupUnit->checkedId();
 if(curt_unit == next_unit)
  return;

 BDraw[curt_unit].hide();
 BDraw[next_unit].show();

 SelectorMol[curt_unit].hide();
 SelectorMol[next_unit].show();

 SelectorAA[curt_unit].hide();
 SelectorAA[next_unit].show();

 ActionMoveSelected->setChecked(false);
}

void Builcule_Main::repaint() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 BDraw[unit].repaint();
}

void Builcule_Main::draw() {
 int unit = get_curt_unit();

 BDraw[unit].clear_obj();

 //系全体を描画
 if(DrawSel[unit] == Draw_Selection::All) {
  if(DrawModel[unit] == Draw_Model::Wireframe)
   BDraw[unit].push_wire();
  else {
   BDraw[unit].push_sphere();
   BDraw[unit].set_sphere_radius(DrawModel[unit]);
   if(DrawModel[unit] == Draw_Model::BallStick)
    BDraw[unit].push_cylinder();
  }
 }

 //選択された分子を描画
 else if(DrawSel[unit] == Draw_Selection::Mol) {
  const auto *mol_idx = SelectorMol[unit].get_selected_idx();
  BUnit[unit].check_mol_atom(mol_idx);
  //系全体を針金で描画
  BDraw[unit].push_wire();
  //球
  BDraw[unit].push_checked_sphere();
  BDraw[unit].set_checked_sphere_radius(DrawModel[unit]);
  //結合
  if(DrawModel[unit] == Draw_Model::BallStick)
   BDraw[unit].push_checked_cylinder();
 }

 //選択されたアミノ酸を描画
 else if(DrawSel[unit] == Draw_Selection::AA) {
  const auto *aa_data = SelectorAA[unit].get_selected_aa_data();
  BUnit[unit].check_aa_atom(aa_data);
  //系全体を針金で描画
  BDraw[unit].push_wire();
  //球
  BDraw[unit].push_checked_sphere();
  BDraw[unit].set_checked_sphere_radius(DrawModel[unit]);
 }

 //選択された原子を描画
 else if(DrawSel[unit] == Draw_Selection::Atom) {
  //系全体を針金で描画
  BDraw[unit].push_wire();
  //球
  BDraw[unit].push_checked_sphere();
  BDraw[unit].set_checked_sphere_radius();
 }

 repaint();
}

void Builcule_Main::keyPressEvent(QKeyEvent *event) {
//フォーカスがセレクタ等に映るとキーイベントが捉えられない
//対症療法：ユニットセレクタでカレントユニットを選択する

 int key = event->key();
 int unit = get_curt_unit();

 //キーボード・ショートカット
 if(key == Qt::Key_PageUp) {
  if(unit == 0) slot_unit1();
  if(unit == 1) slot_unit2();
  if(unit == 2) slot_unit0();
 }
 else if(key == Qt::Key_PageDown) {
  if(unit == 0) slot_unit2();
  if(unit == 1) slot_unit0();
  if(unit == 2) slot_unit1();
 }

 if(!BUnit[unit].get_atom_cnt())
  return;

 if(key == Qt::Key_Delete)
  slot_clear_unit();
 else if(key == Qt::Key_F1)
  slot_clean_up();
 else if(key == Qt::Key_F2) {
  BUnit[unit].add_peptide_H();
  BDraw[unit].clear_picked_obj();
  DrawSel[unit] = Draw_Selection::All;
  draw();
 }
 else if(key == Qt::Key_F3) {
  BUnit[unit].delete_peptide_H();
  BDraw[unit].clear_picked_obj();
  DrawSel[unit] = Draw_Selection::All;
  draw();
 }

 //マウス操作の変更
 if(key == Qt::Key_X)
  BDraw[unit].set_affine_trans(Affine_Trans::EYE_XY);
 else if(key == Qt::Key_Z)
  BDraw[unit].set_affine_trans(Affine_Trans::ZOOM);
}

void Builcule_Main::keyReleaseEvent(QKeyEvent *event) {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 int key = event->key();
 if(key == Qt::Key_X || key == Qt::Key_Z)
  BDraw[unit].set_affine_trans(Affine_Trans::DEFAULT);
}

bool Builcule_Main::select_region(int cnt) {
 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 int picked_cnt = serial->size();
 if(cnt != picked_cnt) {
  QString str = QString::number(cnt);
  QMessageBox::warning(
        this, "警告", str + " 個の原子をピックしてください．");
  return false;
 }

 Region_Err result = Region_Err::TANDEM_ERR;
 if(cnt == 2)
  result = BUnit[unit].select_region((*serial)[0], (*serial)[1]);
 else if(cnt == 3)
  result = BUnit[unit].select_region(
        (*serial)[1], (*serial)[2], (*serial)[0]);
 else if(cnt == 4)
  result = BUnit[unit].select_region(
        (*serial)[0], (*serial)[1], (*serial)[2], (*serial)[3]);
 if(result == Region_Err::TANDEM_ERR) {
  QMessageBox::warning(
        this, "警告", "タンデムに結合した原子をピックしてください．");
  return false;
 }
 else if(result == Region_Err::RING_ERR) {
  QMessageBox::warning(this, "警告", "環の一部です．");
  return false;
 }
 else if(result != Region_Err::NO_ERR) {
  std::cerr << __PRETTY_FUNCTION__ << '\n';
  return false;
 }

 if(cnt == 2) {
  result = BUnit[unit].set_region_direction(
        (*serial)[0], (*serial)[1]);
 }
 else if(cnt == 3) {
  result = BUnit[unit].set_region_center_axis(
        (*serial)[0], (*serial)[1], (*serial)[2]);
 }
 else {  //if(cnt = 4)
  result = BUnit[unit].set_region_center_axis(
        (*serial)[1], (*serial)[2]);
 }

 if(result == Region_Err::AXIS_ERR) {
  QMessageBox::warning(this, "警告", "軸が設定できません．");
  return false;
 }
 return true;
}

void Builcule_Main::backup_for_undo() {
 int unit = get_curt_unit();
 const std::vector<std::shared_ptr<Atom>> *atom_vect
        = BUnit[unit].get_atom_vect();
 if(atom_vect->empty())
  return;

 BUnit[unit].file_backup(ConfigFile.get_wk());

 const Eigen::Vector3d *center = BDraw[unit].get_draw_center();
 double radius = BDraw[unit].get_draw_radius();
 const Eigen::Vector3d *pos = BDraw[unit].get_eye_pos();
 UnitBak.import_undo(
        unit, atom_vect, center, radius, pos, DrawModel[unit]);
}

void Builcule_Main::backup_for_redo() {
 int unit = get_curt_unit();
 const std::vector<std::shared_ptr<Atom>> *atom
        = BUnit[unit].get_atom_vect();
 const Eigen::Vector3d *center = BDraw[unit].get_draw_center();
 double radius = BDraw[unit].get_draw_radius();
 const Eigen::Vector3d *pos = BDraw[unit].get_eye_pos();
 UnitBak.import_redo(
        unit, atom, center, radius, pos, DrawModel[unit]);
}

void Builcule_Main::slot_mol_selection_updated() {
 int unit = get_curt_unit();
 if(DrawSel[unit] == Draw_Selection::All)
  return;
 draw();
}

void Builcule_Main::slot_aa_selection_updated() {
 int unit = get_curt_unit();
 if(DrawSel[unit] == Draw_Selection::All)
  return;
 draw();
}

