#ifndef ___MAIN_WINDOW_H
#define ___MAIN_WINDOW_H

#include "builcule_global.h"
#include "builcule_draw.h"
#include "selector_aa.h"
#include "selector_mol.h"
#include "unit_bak.h"
#include "window_hm.h"
#include "window_sup.h"
#include <builcule/lb2/config_file.h>
#include <builcule/lb2/global.h>
#include <builcule/lb2/copy_mol.h>
#include <builcule/lb2/copy_region.h>
#include <builcule/lb2/substituent.h>
#include <array>
#include <QBoxLayout>
#include <QButtonGroup>
#include <QInputDialog>
#include <QKeyEvent>
#include <QMainWindow>
#include <QMenuBar>
#include <QMessageBox>
#include <QRadioButton>
#include <QToolBar>

class Builcule_Main : public QMainWindow {
 Q_OBJECT

 public:
  Builcule_Main(QWidget *parent = nullptr);

 private:
  //保守性を考え，コンストラクタから複数の関数を呼び出す
  //コンストラクタが煩雑になるので，ウィジェットを宣言
  QWidget *WidgetCentral;
  QMenuBar *MenuBar;
  QMenu *MenuFile;
  QMenu *MenuEdit;
  QMenu *MenuView;
  QMenu *MenuSelect;
  QMenu *MenuExp;
  QToolBar *hToolBar;
  QToolBar *vToolBar;
  QWidget *WidgetUnitMol;
  QVBoxLayout *LayoutUnitMol;
  std::array<QRadioButton *, 3> RadioButtonUnit;
  QButtonGroup *GroupUnit;
  std::array<Selector_Mol, 3> SelectorMol;
  QWidget *WidgetAA;
  QVBoxLayout *LayoutAA;
  std::array<Selector_AA, 3> SelectorAA;

  //コンストラクタから呼び出される関数
  void create_layout();
  void create_menu_bar();
  void create_h_tool_bar();
  void create_v_tool_bar();
  void create_widget_unit_mol();
  void create_widget_aa();
  void set_size();

  //試しに BUnit を global に置いてみたら，マウスで回転できなかった
  std::array<Builcule_Unit, 3> BUnit;
  std::array<Builcule_Draw, 3> BDraw;
  std::array<QString, 3> FileName;  //直近に開いたファイル名
  Config_File ConfigFile;  //隠しフォルダに設定ファイルを格納

  Unit_Bak UnitBak;
  Copy_Mol CopyMol;
  Copy_Region CopyRegion;
  Substituent Subst;

  //状態の制御
  std::array<Draw_Model, 3> DrawModel;
  std::array<Draw_Selection, 3> DrawSel;
  QAction *ActionMoveSelected;  //トグルボタン

  //子ウィンドウ
  Window_Sup WinSup;  //Unit0 と Unit1 を重ね書きする
  Window_HM *WinHM;  //複数の関数からアクセスするのでポインタを宣言しておく

  //キーイベント
  void keyPressEvent(QKeyEvent *event);
  void keyReleaseEvent(QKeyEvent *event);
  //その他
  int get_curt_unit();
  bool select_region(int cnt);
  void backup_for_undo();
  void backup_for_redo();
  void repaint();  //BDraw::repaint() を呼び出す
  void draw();  //BDraw の描画オブジェクトを再生
  bool match_ext_and_type(
        const QString &name, const QString &type) const;
  void sup_pick_by_matrix(
    const std::vector<int> *pick0, const std::vector<int> *pick1);

 private slots:
  //メニューバー ファイル
  void slot_open();
  void slot_save();
  void slot_import_via_babel();
  void slot_export_via_babel();
  void slot_export_fasta();
  void slot_show_file_name();

  //void close() は Qt で定義されている関数
  //メニューバー 編集
  void slot_undo();
  void slot_redo();
  void slot_add_alkane();  //backup();
  void slot_add_peptide();  //backup();
  void slot_set_length_by_value();  //backup();
  void slot_set_angle_by_value();  //backup();
  void slot_set_dihead_by_value();  //backup();
  void slot_add_subst();
  void slot_clean_up();  //backup();

  //メニューバー 表示と選択
  void slot_ball_stick();
  void slot_waals();
  void slot_wire();
  void slot_show_sup_win();
  void slot_pick_to_mol();
  void slot_pick_to_aa();
  void slot_pick_to_neighbor();
  void slot_selected_mol_ball();
  void slot_selected_mol_waals();
  void slot_mol_to_neighbor();
  void slot_selected_aa_ball();
  void slot_selected_aa_waals();
  void slot_aa_to_neighbor();

  //実験
  void slot_minimum_all();  //backup();
  void slot_minimum_mol();  //backup();
  void slot_conformation_all();  //backup();
  void slot_conformation_mol();  //backup();
  void slot_adjust_mol_pos();  //backup();
  void slot_adjust_structure();  //backup()
  void slot_interaction();  //backup()
  void slot_homology();

  //水平ツールバーのスロット
  void slot_clear_picked();
  void slot_meas_dist();
  void slot_meas_angle();
  void slot_meas_dihead();
  void slot_alter_length_mouse();
  void slot_alter_angle_mouse();
  void slot_alter_dihead_mouse();
  void slot_centering();
  void slot_move_selected();
  void slot_pick_super();
  void slot_seq_super();
  //垂直ツールバーのスロット
  void slot_change_element();  //backup();
  void slot_delete_atom();  //backup();
  void slot_create_bond();  //backup();
  void slot_delete_bond();  //backup();
  bool slot_region_copy();
  void slot_region_cut();  //backup();
  void slot_region_connect();  //backup();
  void slot_elongation();  //backup();
  void slot_substitute();  //backup();
  void slot_add_hydrogen();
  void slot_delete_hydrogen();
  void slot_clear_unit();  //backup();
  //ユニットの選択
  void slot_unit0();
  void slot_unit1();
  void slot_unit2();
  void slot_unit_changed();
  //分子の選択のスロット
  void slot_mol_selection_updated();
  void slot_mol_copy();
  void slot_mol_cut();  //backup();
  void slot_mol_paste();  //backup();
  //アミノ酸の選択のスロット
  void slot_aa_selection_updated();
  void slot_aa_selection_clear();
  void slot_aa_selection_invert();
  void slot_aa_delete();  //backup();
  void slot_aa_mutate();  //backup();

  //子ウィンドウの変更を Builcule_Draw に反映させる
  void slot_redraw() { repaint(); }

  //ホモロジーモデリングの後半
  void slot_after_hm();
};

#endif
