#include "builcule_main.h"
#include <QDesktopWidget>

Builcule_Main::Builcule_Main(QWidget *parent)
 : QMainWindow(parent),
   MenuBar(menuBar()),
   Subst(ConfigFile.get_wk()),
   DrawModel(
        {Draw_Model::BallStick,
        Draw_Model::BallStick,
        Draw_Model::BallStick}),
   DrawSel(
        {Draw_Selection::All,
        Draw_Selection::All,
        Draw_Selection::All}),
   WinSup(this, &BUnit[0], &BUnit[1])
{
 //GUI
 create_layout();
 create_menu_bar();
 create_h_tool_bar();
 create_v_tool_bar();
 create_widget_unit_mol();
 create_widget_aa();
 set_size();

 //Window_Sup での変更を Builcule_Draw に反映させる
 connect(&WinSup, SIGNAL(sig_drawed()),
        this, SLOT(slot_redraw()));

 //子ウィジェットも含め表示しないと，get_curt_unit() が -1 を返す
 show();
}

void Builcule_Main::create_layout() {
 //セントラルウィジェット
 WidgetCentral = new QWidget(this);
 QHBoxLayout *layout_central = new QHBoxLayout;
 setCentralWidget(WidgetCentral);
 WidgetCentral->setLayout(layout_central);

 //横ツールバー
 hToolBar = addToolBar("hToolBar");
 hToolBar->setToolButtonStyle(Qt::ToolButtonTextUnderIcon);

 //縦ツールバー
 vToolBar = new QToolBar(WidgetCentral);
 vToolBar->setToolButtonStyle(Qt::ToolButtonTextUnderIcon);
 vToolBar->setOrientation(Qt::Vertical);
 layout_central->addWidget(vToolBar);

 //描画ウィジェット
 for(int i = 0; i < 3; ++i) {
  BDraw[i].setParent(WidgetCentral);
  layout_central->addWidget(&BDraw[i]);
  BDraw[i].set_unit(&BUnit[i]);
 }
 BDraw[1].hide();
 BDraw[2].hide();

 //ユニットセレクタと分子エディタ
 WidgetUnitMol = new QWidget(WidgetCentral);
 layout_central->addWidget(WidgetUnitMol);

 //アミノ酸エディタ
 WidgetAA = new QWidget(WidgetCentral);
 layout_central->addWidget(WidgetAA);
}

void Builcule_Main::create_menu_bar() {
 MenuFile = new QMenu(tr("ファイル(&F)"), MenuBar);
 MenuEdit = new QMenu(tr("編集(&E)"), MenuBar);
 MenuView = new QMenu(tr("表示(&V)"), MenuBar);
 MenuSelect = new QMenu(tr("選択(&S)"), MenuBar);
 MenuExp = new QMenu(tr("実験(&X)"), MenuBar);

 MenuBar->addMenu(MenuFile);
 MenuBar->addMenu(MenuEdit);
 MenuBar->addMenu(MenuView);
 MenuBar->addMenu(MenuSelect);
 MenuBar->addMenu(MenuExp);

 //ファイル
 QAction *actionOpen
    = new QAction(tr("開く(&O)"), MenuBar);
 connect(actionOpen, SIGNAL(triggered()),
   this, SLOT(slot_open()));
 MenuFile->addAction(actionOpen);

 QAction *actionSave
    = new QAction(tr("保存(&S)"), MenuBar);
 connect(actionSave, SIGNAL(triggered()),
   this, SLOT(slot_save()));
 MenuFile->addAction(actionSave);

 QAction *actionImportViaBabel
    = new QAction(tr("Open Babel でインポート"), MenuBar);
 connect(actionImportViaBabel, SIGNAL(triggered()),
   this, SLOT(slot_import_via_babel()));
 MenuFile->addAction(actionImportViaBabel);

 QAction *actionExportViaBabel
    = new QAction(tr("Open Babel でエクスポート"), MenuBar);
 connect(actionExportViaBabel, SIGNAL(triggered()),
   this, SLOT(slot_export_via_babel()));
 MenuFile->addAction(actionExportViaBabel);

 QAction *actionExportFasta
    = new QAction(tr("FASTA 形式でエクスポート"), MenuBar);
 connect(actionExportFasta, SIGNAL(triggered()),
   this, SLOT(slot_export_fasta()));
 MenuFile->addAction(actionExportFasta);

 QAction *actionShowFileName
    = new QAction(tr("直近に開いたファイル名"), MenuBar);
 connect(actionShowFileName, SIGNAL(triggered()),
   this, SLOT(slot_show_file_name()));
 MenuFile->addAction(actionShowFileName);

 QAction *actionQuit
    = new QAction(tr("終了(&Q)"), MenuBar);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));
 MenuFile->addAction(actionQuit);

 //編集
 QAction *actionUndo
    = new QAction(tr("アンドゥ(&U)"), MenuBar);
 connect(actionUndo, SIGNAL(triggered()),
   this, SLOT(slot_undo()));
 MenuEdit->addAction(actionUndo);

 QAction *actionRedo
    = new QAction(tr("リドゥ(&R)"), MenuBar);
 connect(actionRedo, SIGNAL(triggered()),
   this, SLOT(slot_redo()));
 MenuEdit->addAction(actionRedo);

 QAction *actionAddAlkane
    = new QAction(tr("n-アルカンを追加(&C)"), MenuBar);
 connect(actionAddAlkane, SIGNAL(triggered()),
   this, SLOT(slot_add_alkane()));
 MenuEdit->addAction(actionAddAlkane);

 QAction *actionAddPeptide
    = new QAction(tr("ペプチドを追加(&P)"), MenuBar);
 connect(actionAddPeptide, SIGNAL(triggered()),
   this, SLOT(slot_add_peptide()));
 MenuEdit->addAction(actionAddPeptide);

 QAction *actionAlterLenByValue
    = new QAction(tr("値を指定して結合距離を変更"), MenuBar);
 connect(actionAlterLenByValue, SIGNAL(triggered()),
   this, SLOT(slot_set_length_by_value()));
 MenuEdit->addAction(actionAlterLenByValue);

 QAction *actionAlterAngleByValue
    = new QAction(tr("値を指定して角結合角を変更"), MenuBar);
 connect(actionAlterAngleByValue, SIGNAL(triggered()),
   this, SLOT(slot_set_angle_by_value()));
 MenuEdit->addAction(actionAlterAngleByValue);

 QAction *actionAlterDiheadByValue
    = new QAction(tr("値を指定して二面角を変更"), MenuBar);
 connect(actionAlterDiheadByValue, SIGNAL(triggered()),
   this, SLOT(slot_set_dihead_by_value()));
 MenuEdit->addAction(actionAlterDiheadByValue);

 QAction *actionAddSubst
    = new QAction(tr("置換基ストックに追加"), MenuBar);
 connect(actionAddSubst, SIGNAL(triggered()),
   this, SLOT(slot_add_subst()));
 MenuEdit->addAction(actionAddSubst);

 QAction *actionCleanUp
    = new QAction(tr("クリーンアップ(&A)"), MenuBar);
 connect(actionCleanUp, SIGNAL(triggered()),
   this, SLOT(slot_clean_up()));
 MenuEdit->addAction(actionCleanUp);

 //表示
 QAction *actionBall
    = new QAction(tr("棒球(&B)"), MenuBar);
 connect(actionBall, SIGNAL(triggered()),
   this, SLOT(slot_ball_stick()));
 MenuView->addAction(actionBall);

 QAction *actionWaals
    = new QAction(tr("空間充填(&S)"), MenuBar);
 connect(actionWaals, SIGNAL(triggered()),
   this, SLOT(slot_waals()));
 MenuView->addAction(actionWaals);

 QAction *actionWire
    = new QAction(tr("針金(&W)"), MenuBar);
 connect(actionWire, SIGNAL(triggered()),
   this, SLOT(slot_wire()));
 MenuView->addAction(actionWire);

 QAction *actionSupWin
    = new QAction(tr("ユニット 0 と 1 を重ね書き(&I)"), MenuBar);
 connect(actionSupWin, SIGNAL(triggered()),
   this, SLOT(slot_show_sup_win()));
 MenuView->addAction(actionSupWin);

 QAction *actionSelectedMolBall
    = new QAction(tr("選択した分子を棒球で"), MenuBar);
 connect(actionSelectedMolBall, SIGNAL(triggered()),
   this, SLOT(slot_selected_mol_ball()));
 MenuView->addAction(actionSelectedMolBall);

 QAction *actionSelectedMolWaals
    = new QAction(tr("選択した分子を空間充填で"), MenuBar);
 connect(actionSelectedMolWaals, SIGNAL(triggered()),
   this, SLOT(slot_selected_mol_waals()));
 MenuView->addAction(actionSelectedMolWaals);

 QAction *actionSelectedAABall
    = new QAction(tr("選択したアミノ酸を棒球で"), MenuBar);
 connect(actionSelectedAABall, SIGNAL(triggered()),
   this, SLOT(slot_selected_aa_ball()));
 MenuView->addAction(actionSelectedAABall);

 QAction *actionSelectedAAWaals
    = new QAction(tr("選択したアミノ酸を空間充填で"), MenuBar);
 connect(actionSelectedAAWaals, SIGNAL(triggered()),
   this, SLOT(slot_selected_aa_waals()));
 MenuView->addAction(actionSelectedAAWaals);

 //選択
 QAction *actionPickToMol
    = new QAction(tr("ピックした原子が属する分子を選択"), MenuBar);
 connect(actionPickToMol, SIGNAL(triggered()),
   this, SLOT(slot_pick_to_mol()));
 MenuSelect->addAction(actionPickToMol);

 QAction *actionPickToAA
    = new QAction(tr("ピックした原子が属するアミノ酸を選択"), MenuBar);
 connect(actionPickToAA, SIGNAL(triggered()),
   this, SLOT(slot_pick_to_aa()));
 MenuSelect->addAction(actionPickToAA);

 QAction *actionPickToNeighbor
    = new QAction(tr("ピックした原子の近傍原子を検知"), MenuBar);
 connect(actionPickToNeighbor, SIGNAL(triggered()),
   this, SLOT(slot_pick_to_neighbor()));
 MenuSelect->addAction(actionPickToNeighbor);

 QAction *actionMolToNeighbor
    = new QAction(tr("選択した分子の近傍原子を検知"), MenuBar);
 connect(actionMolToNeighbor, SIGNAL(triggered()),
   this, SLOT(slot_mol_to_neighbor()));
 MenuSelect->addAction(actionMolToNeighbor);

 QAction *actionAAToNeighborAA
    = new QAction(tr("選択したアミノ酸の近傍原子を検知"), MenuBar);
 connect(actionAAToNeighborAA, SIGNAL(triggered()),
   this, SLOT(slot_aa_to_neighbor()));
 MenuSelect->addAction(actionAAToNeighborAA);

 //実験
 QAction *actionHomology
    = new QAction(tr("ホモロジーモデリング"), MenuBar);
 connect(actionHomology, SIGNAL(triggered()),
   this, SLOT(slot_homology()));
 MenuExp->addAction(actionHomology);

 QAction *actionAdjustStructure
    = new QAction(tr("選択した分子の構造を調整"), MenuBar);
 connect(actionAdjustStructure, SIGNAL(triggered()),
   this, SLOT(slot_adjust_structure()));
 MenuExp->addAction(actionAdjustStructure);

 QAction *actionAdjustMolPos
    = new QAction(tr("分子の位置を調整"), MenuBar);
 connect(actionAdjustMolPos, SIGNAL(triggered()),
   this, SLOT(slot_adjust_mol_pos()));
 MenuExp->addAction(actionAdjustMolPos);

 QAction *actionInteraction
    = new QAction(tr("分子間相互作用"), MenuBar);
 connect(actionInteraction, SIGNAL(triggered()),
   this, SLOT(slot_interaction()));
 MenuExp->addAction(actionInteraction);

 QAction *actionMinAll
    = new QAction(tr("エネルギー極小化（全分子）"), MenuBar);
 connect(actionMinAll, SIGNAL(triggered()),
   this, SLOT(slot_minimum_all()));
 MenuExp->addAction(actionMinAll);

 QAction *actionMinMol
    = new QAction(tr("エネルギー極小化（選択分子）"), MenuBar);
 connect(actionMinMol, SIGNAL(triggered()),
   this, SLOT(slot_minimum_mol()));
 MenuExp->addAction(actionMinMol);

 QAction *actionConfAll
    = new QAction(tr("コンフォメーション探索（全分子）"), MenuBar);
 connect(actionConfAll, SIGNAL(triggered()),
   this, SLOT(slot_conformation_all()));
 MenuExp->addAction(actionConfAll);

 QAction *actionConfMol
    = new QAction(tr("コンフォメーション探索（選択分子）"), MenuBar);
 connect(actionConfMol, SIGNAL(triggered()),
   this, SLOT(slot_conformation_mol()));
 MenuExp->addAction(actionConfMol);
}

void Builcule_Main::create_h_tool_bar() {
 const QIcon icon_clear_picked("://icon/clear_picked.png");
 QAction *actionClearPicked
    = new QAction(icon_clear_picked, tr("ピックを解除"), hToolBar);
 actionClearPicked->setToolTip(
     "ピックにより赤紫で表示されている原子の色が通常色に戻ります");
 connect(actionClearPicked, SIGNAL(triggered()),
   this, SLOT(slot_clear_picked()));
 hToolBar->addAction(actionClearPicked);

 const QIcon icon_centering("://icon/centering.png");
 QAction *actionCentering
    = new QAction(icon_centering, tr("センタリング"), hToolBar);
 actionCentering->setToolTip(
     "ユニットの中心を原点に移動し，ユニットの全分子が描画されるようにします");
 connect(actionCentering, SIGNAL(triggered()),
   this, SLOT(slot_centering()));
 hToolBar->addAction(actionCentering);

 const QIcon icon_meas_dist("://icon/meas_dist.png");
 QAction *actionMeasDist
    = new QAction(icon_meas_dist, tr("距離を測定"), hToolBar);
 actionMeasDist->setToolTip(
     "2 原子をピックしてクリックすると，原子間距離がステータスバーに表示されます");
 connect(actionMeasDist, SIGNAL(triggered()),
   this, SLOT(slot_meas_dist()));
 hToolBar->addAction(actionMeasDist);

 const QIcon icon_meas_angle("://icon/meas_angle.png");
 QAction *actionMeasAngle
    = new QAction(icon_meas_angle, tr("角度を測定"), hToolBar);
 actionMeasAngle->setToolTip(
     "3 原子をピックしてクリックすると，角度がステータスバーに表示されます");
 connect(actionMeasAngle, SIGNAL(triggered()),
   this, SLOT(slot_meas_angle()));
 hToolBar->addAction(actionMeasAngle);

 const QIcon icon_meas_dihead("://icon/meas_dihead.png");
 QAction *actionMeasDihead
    = new QAction(icon_meas_dihead, tr("二面角を測定"), hToolBar);
 actionMeasDihead->setToolTip(
     "4 原子をピックしてクリックすると，二面角がステータスバーに表示されます");
 connect(actionMeasDihead, SIGNAL(triggered()),
   this, SLOT(slot_meas_dihead()));
 hToolBar->addAction(actionMeasDihead);

 const QIcon icon_alter_length("://icon/alter_length.png");
 QAction *actionAlterLenMouse
    = new QAction(icon_alter_length, tr("結合長を変更"), hToolBar);
 actionAlterLenMouse->setToolTip(
     "結合した 2 原子をピックしてこのボタンをクリックし，マウスの左ボタンを押したままドラッグ");
 connect(actionAlterLenMouse, SIGNAL(triggered()),
   this, SLOT(slot_alter_length_mouse()));
 hToolBar->addAction(actionAlterLenMouse);

 const QIcon icon_alter_angle("://icon/alter_angle.png");
 QAction *actionAlterAngleMouse
    = new QAction(icon_alter_angle, tr("結合角を変更"), hToolBar);
 actionAlterAngleMouse->setToolTip(
     "直列に結合した原子を 3 個ピックしてこのボタンをクリックし，マウスの左ボタンを押したままドラッグ");
 connect(actionAlterAngleMouse, SIGNAL(triggered()),
   this, SLOT(slot_alter_angle_mouse()));
 hToolBar->addAction(actionAlterAngleMouse);

 const QIcon icon_alter_dihead("://icon/alter_dihead.png");
 QAction *actionAlterDiheadMouse
    = new QAction(icon_alter_dihead, tr("二面角を変更"), hToolBar);
 actionAlterDiheadMouse->setToolTip(
     "直列に結合した原子を 4 個ピックしてこのボタンをクリックし，マウスの左ボタンを押したままドラッグ");
 connect(actionAlterDiheadMouse, SIGNAL(triggered()),
   this, SLOT(slot_alter_dihead_mouse()));
 hToolBar->addAction(actionAlterDiheadMouse);

 const QIcon icon_move_selected("://icon/move_selected.png");
 ActionMoveSelected
    = new QAction(icon_move_selected, tr("選択分子の移動"), hToolBar);
 //ActionMoveSelected->setCheckable(true);  //トグルボタンにする.中止
 ActionMoveSelected->setToolTip(
     "分子エディタで選択されている分子のみ，マウスで移動・回転できます");
 connect(ActionMoveSelected, SIGNAL(triggered()),
   this, SLOT(slot_move_selected()));
 hToolBar->addAction(ActionMoveSelected);

 const QIcon icon_pick_super("://icon/pick_super.png");
 QAction *actionPickSuper
    = new QAction(icon_pick_super, tr("ピックで重合せ"), hToolBar);
 actionPickSuper->setToolTip(
     "ピックした原子を基準にして，ユニット 0 とユニット 1 を重ね合わせます");
 connect(actionPickSuper, SIGNAL(triggered()),
   this, SLOT(slot_pick_super()));
 hToolBar->addAction(actionPickSuper);

 const QIcon icon_seq_super("://icon/seq_super.png");
 QAction *actionSeqSuper
    = new QAction(icon_seq_super, tr("配列で重合せ"), hToolBar);
 actionSeqSuper->setToolTip(
     "配列アラインメントに基づき，ユニット 0 にユニット 1 を重ね合わせます");
 connect(actionSeqSuper, SIGNAL(triggered()),
   this, SLOT(slot_seq_super()));
 hToolBar->addAction(actionSeqSuper);
}

void Builcule_Main::create_v_tool_bar() {
 const QIcon icon_change_element("://icon/change_element.png");
 QAction *actionAlterElement
    = new QAction(icon_change_element, tr("元素の変更"), vToolBar);
 actionAlterElement->setToolTip(
     "原子をピックしてこのボタンをクリックすると周期表が表示されます．元素を選択し，OK ボタンを押してください");
 connect(actionAlterElement, SIGNAL(triggered()),
   this, SLOT(slot_change_element()));
 vToolBar->addAction(actionAlterElement);

 const QIcon icon_delete_atom("://icon/delete_atom.png");
 QAction *actionDeleteAtom
    = new QAction(icon_delete_atom, tr("原子の削除"), vToolBar);
 actionDeleteAtom->setToolTip(
     "原子をピックしてこのボタンをクリックしてください" );
 connect(actionDeleteAtom, SIGNAL(triggered()),
   this, SLOT(slot_delete_atom()));
 vToolBar->addAction(actionDeleteAtom);

 const QIcon icon_create_bond("://icon/create_bond.png");
 QAction *actionCreateBond
    = new QAction(icon_create_bond, tr("結合の生成"), vToolBar);
 actionCreateBond->setToolTip(
     "互いに結合していない 2 原子をピックしてこのボタンをクリックしてください" );
 connect(actionCreateBond, SIGNAL(triggered()),
   this, SLOT(slot_create_bond()));
 vToolBar->addAction(actionCreateBond);

 const QIcon icon_delete_bond("://icon/delete_bond.png");
 QAction *actionDeleteBond
    = new QAction(icon_delete_bond, tr("結合の削除"), vToolBar);
 actionDeleteBond->setToolTip(
     "互いに結合した 2 原子をピックしてこのボタンをクリックしてください" );
 connect(actionDeleteBond, SIGNAL(triggered()),
   this, SLOT(slot_delete_bond()));
 vToolBar->addAction(actionDeleteBond);

 const QIcon icon_elongation("://icon/elongation.png");
 QAction *actionElongation
    = new QAction(icon_elongation, tr("分岐と伸長"), vToolBar);
 actionElongation->setToolTip(
     "1 原子をピックしてこのボタンをクリックすると周期表と軌道の型が表示されます．元素と軌道型を選択して OK ボタンを押してください" );
 connect(actionElongation, SIGNAL(triggered()),
   this, SLOT(slot_elongation()));
 vToolBar->addAction(actionElongation);

 const QIcon icon_copy_region("://icon/copy_region.png");
 QAction *actionCopyRegion
    = new QAction(icon_copy_region, tr("領域をコピー"), vToolBar);
 actionCopyRegion->setToolTip(
     "互いに結合した原子を 2 個ピックしてこのボタンをクリックしてください．後でピックした側の領域がコピーされます" );
 connect(actionCopyRegion, SIGNAL(triggered()),
   this, SLOT(slot_region_copy()));
 vToolBar->addAction(actionCopyRegion);

 const QIcon icon_cut_region("://icon/cut_region.png");
 QAction *actionCutRegion
    = new QAction(icon_cut_region, tr("領域をカット"), vToolBar);
 actionCutRegion->setToolTip(
     "互いに結合した原子を 2 個ピックしてこのボタンをクリックしてください．後でピックした側の領域がカットされます" );
 connect(actionCutRegion, SIGNAL(triggered()),
   this, SLOT(slot_region_cut()));
 vToolBar->addAction(actionCutRegion);

 const QIcon icon_connect_region("://icon/connect_region.png");
 QAction *actionConnectRegion
    = new QAction(icon_connect_region, tr("領域を接続"), vToolBar);
 actionConnectRegion->setToolTip(
     "結合が 1 個の原子をピックしてこのボタンをクリックしてください．直前にカットまたはコピーされた領域が接続されます" );
 connect(actionConnectRegion, SIGNAL(triggered()),
   this, SLOT(slot_region_connect()));
 vToolBar->addAction(actionConnectRegion);

 const QIcon icon_substitute("://icon/substitute.png");
 QAction *actionSubstitute
    = new QAction(icon_substitute, tr("置換基接続"), vToolBar);
 actionSubstitute->setToolTip(
     "結合が 1 個の原子をピックしてこのボタンをクリックすると置換基リストが表示されます．接続する置換基を選択し OK ボタンを押してください" );
 connect(actionSubstitute, SIGNAL(triggered()),
   this, SLOT(slot_substitute()));
 vToolBar->addAction(actionSubstitute);

 const QIcon icon_add_hydrogen("://icon/add_hydrogen.png");
 QAction *actionAddHydrogen
    = new QAction(icon_add_hydrogen, tr("水素付加"), vToolBar);
 actionAddHydrogen->setToolTip(
     "水素が欠落しているペプチドに水素を付加します" );
 connect(actionAddHydrogen, SIGNAL(triggered()),
   this, SLOT(slot_add_hydrogen()));
 vToolBar->addAction(actionAddHydrogen);

 const QIcon icon_remove_hydrogen("://icon/remove_hydrogen.png");
 QAction *actionRemoveHydrogen
    = new QAction(icon_remove_hydrogen, tr("水素除去"), vToolBar);
 actionRemoveHydrogen->setToolTip(
     "ペプチドから水素を除去します" );
 connect(actionRemoveHydrogen, SIGNAL(triggered()),
   this, SLOT(slot_delete_hydrogen()));
 vToolBar->addAction(actionRemoveHydrogen);

 const QIcon icon_clear_unit("://icon/clear_unit.png");
 QAction *actionClearUnit1
    = new QAction(icon_clear_unit, tr("クリア"), vToolBar);
 actionClearUnit1->setToolTip(
     "このユニットの全分子を削除します" );
 connect(actionClearUnit1, SIGNAL(triggered()),
   this, SLOT(slot_clear_unit()));
 vToolBar->addAction(actionClearUnit1);
}

void Builcule_Main::create_widget_unit_mol() {
 LayoutUnitMol = new QVBoxLayout(WidgetUnitMol);

 //ユニットセレクタ
 GroupUnit= new QButtonGroup(WidgetUnitMol);
 for(int i = 0; i != 3; ++i) {
  RadioButtonUnit[i] = new QRadioButton(WidgetUnitMol);
  RadioButtonUnit[i]->setText("ユニット " + QString::number(i));
  GroupUnit->addButton(RadioButtonUnit[i], i);
  LayoutUnitMol->addWidget(RadioButtonUnit[i]);
 }
 RadioButtonUnit[0]->setChecked(true);

 connect(GroupUnit, SIGNAL(buttonClicked(int)), this, SLOT(slot_unit_changed()));

 //分子エディタ
 for(int i = 0; i < 3; ++i) {
  SelectorMol[i].setParent(WidgetUnitMol);

  connect(&SelectorMol[i], SIGNAL(selection_updated()),
        this, SLOT(slot_mol_selection_updated()));
  connect(&SelectorMol[i], SIGNAL(button_copy()),
        this, SLOT(slot_mol_copy()));
  connect(&SelectorMol[i], SIGNAL(button_cut()),
        this, SLOT(slot_mol_cut()));
  connect(&SelectorMol[i], SIGNAL(button_paste()),
        this, SLOT(slot_mol_paste()));

  LayoutUnitMol->addWidget(&SelectorMol[i]);
 }

 SelectorMol[1].hide();
 SelectorMol[2].hide();
}

void Builcule_Main::create_widget_aa() {
 LayoutAA = new QVBoxLayout(WidgetAA);

 for(int i = 0; i < 3; ++i) {
  SelectorAA[i].setParent(WidgetAA);
  connect(&SelectorAA[i], SIGNAL(selection_updated()),
      this, SLOT(slot_aa_selection_updated()));
  connect(&SelectorAA[i], SIGNAL(button_delete()),
        this, SLOT(slot_aa_delete()));
  connect(&SelectorAA[i], SIGNAL(button_mutate()),
        this, SLOT(slot_aa_mutate()));

  LayoutAA->addWidget(&SelectorAA[i]);
 }

 SelectorAA[1].hide();
 SelectorAA[2].hide();
}

void Builcule_Main::set_size() {
 //全体のサイズ．開発環境の解像度より低い場合は最大化
 QDesktopWidget screen;
 int s_width = screen.width();
 int s_height = screen.height();
 int d_width = 1920;  //開発環境の解像度
 int d_height = 1080;  //開発環境の解像度
 if(s_width < d_width || s_height < d_height)  //最大化
  setWindowState(windowState() ^ Qt::WindowMaximized);
 else  //パーツのサイズでウィンドウサイズが決まる
  setMaximumSize(screen.width(), screen.height());

 //パーツのサイズ．開発環境の解像度でうまく表示できたサイズ
 //描画領域のサイズは Widget_Draw_Base に記す
 //これは描画ウィンドウを派生させる必要があるため
 hToolBar->setMinimumWidth(1150);
 vToolBar->setMinimumHeight(700);
 LayoutUnitMol->setContentsMargins(0, 0, 0, 0);
 LayoutAA->setContentsMargins(0, 0, 0, 0);
 vToolBar->setMaximumWidth(130);
 WidgetUnitMol->setMaximumWidth(130);
 WidgetAA->setMaximumWidth(180);
}

