#include "builcule_main.h"
#include <builcule/lb2/create_pept_bone.h>

void Builcule_Main::slot_undo() {
 //取得
 int unit = get_curt_unit();
 const auto *backup = UnitBak.pop_undo(unit);
 if(backup->AtomVect.empty()) {
  QMessageBox::warning(this, "警告", "バックアップがありません．");
  return;
 }

 //再構築
 BUnit[unit].clear();
 BUnit[unit].import_atom_vect(&(backup->AtomVect));
 BUnit[unit].detect_mol();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 BDraw[unit].set_draw_center(&backup->Center);
 BDraw[unit].set_draw_radius(backup->Radius);
 BDraw[unit].set_eye_pos(&backup->Pos);
 DrawModel[unit] = backup->Model;
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_redo() {
 //取得
 int unit = get_curt_unit();
 const auto *backup = UnitBak.get_redo(unit);
 if(backup->AtomVect.empty()) {
  QMessageBox::warning(this, "警告", "バックアップがありません．");
  return;
 }

 //再構築
 BUnit[unit].clear();
 BUnit[unit].import_atom_vect(&(backup->AtomVect));
 BUnit[unit].detect_mol();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 BDraw[unit].set_draw_center(&backup->Center);
 BDraw[unit].set_draw_radius(backup->Radius);
 BDraw[unit].set_eye_pos(&backup->Pos);
 DrawModel[unit] = backup->Model;
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_add_subst() {
 if(!select_region(2))
  return;

 QInputDialog dialog(this);
 dialog.setLabelText("置換基の名前");
 dialog.setInputMode(QInputDialog::TextInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 QString val = dialog.textValue();
 std::string name = val.toStdString();

 int unit = get_curt_unit();
 const auto &region_vect = BUnit[unit].get_region();
 const auto &root_atom = BUnit[unit].get_region_root();
 Subst.add_subst(root_atom, region_vect);
 Subst.add_name(&name);
}

void Builcule_Main::slot_set_length_by_value() {
 if(!select_region(2))
  return;

 QInputDialog dialog(this);
 dialog.setLabelText("変更後の結合長(Å)");
 dialog.setInputMode(QInputDialog::DoubleInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double val = dialog.doubleValue();

 int unit = get_curt_unit();
 double length = BDraw[unit].measure_distance();

 backup_for_undo();
 BUnit[unit].move_region(val - length);
 backup_for_redo();

 slot_clear_picked();
}

void Builcule_Main::slot_set_angle_by_value() {
 if(!select_region(3))
  return;

 int unit = get_curt_unit();
 double curt_angle = BDraw[unit].measure_angle();

 QInputDialog dialog(this);
 dialog.setDoubleDecimals(2);
 dialog.setDoubleRange(0.0, 180.0);
 dialog.setLabelText("変更後の結合角(0〜180°)");
 dialog.setInputMode(QInputDialog::DoubleInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double setting_val = dialog.doubleValue();
 if(setting_val < 0.0 || 180.0 < setting_val) {
  QMessageBox::warning(this, "警告", "入力した角度が範囲外です．");
  return;
 }
 setting_val *= DEGtoRAD;

 const std::vector<int> *serial = BDraw[unit].get_picked_serial();

 backup_for_undo();
 BUnit[unit].set_region_center_axis(
        (*serial)[0], (*serial)[1], (*serial)[2]);
 BUnit[unit].rotate_region(setting_val - curt_angle);
 backup_for_redo();

 slot_clear_picked();
}

void Builcule_Main::slot_set_dihead_by_value() {
 if(!select_region(4))
  return;

 int unit = get_curt_unit();
 double curt_angle = BDraw[unit].measure_diheadral();

 QInputDialog dialog(this);
 dialog.setDoubleDecimals(2);
 dialog.setDoubleRange(-180.0, 180.0);
 dialog.setLabelText("変更後の二面角(-180.0〜180.0°)");
 dialog.setInputMode(QInputDialog::DoubleInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double setting_val = dialog.doubleValue();
 if(setting_val < -180.0 || 180.0 < setting_val) {
  QMessageBox::warning(this, "警告", "入力した角度が範囲外です．");
  return;
 }
 setting_val *= DEGtoRAD;

 const std::vector<int> *serial = BDraw[unit].get_picked_serial();

 backup_for_undo();
 BUnit[unit].set_region_center_axis((*serial)[1], (*serial)[2]);
 BUnit[unit].rotate_region(curt_angle - setting_val);
 backup_for_redo();

 slot_clear_picked();
}

void Builcule_Main::slot_clean_up() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 int atom0 = BUnit[unit].get_atom_cnt();
 int mol0 = BUnit[unit].get_mol_cnt();

 backup_for_undo();
 BUnit[unit].clean_up();
 backup_for_redo();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();

 int atom1 = BUnit[unit].get_atom_cnt();
 int mol1 = BUnit[unit].get_mol_cnt();
 QString str0 = "原子数："
    + QString::number(atom0) + " -> " +QString::number(atom1);
 QString str1 = "\n分子数："
    + QString::number(mol0) + " -> " +QString::number(mol1);
 //str0 と str1 は，自動的に改行された
 QMessageBox::information(this, "情報", str0 + str1);
}

void Builcule_Main::slot_add_alkane() {
 QInputDialog dialog(this);
 dialog.setLabelText("アルカンの炭素数(1〜30)");
 dialog.setInputMode(QInputDialog::IntInput);
 dialog.setIntRange(1, 30);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double val = dialog.intValue();
 Create_Bone mol;
 mol.create_alkane(val);

 int unit = get_curt_unit();
 int mol_cnt_before = BUnit[unit].get_mol_cnt();

 backup_for_undo();
 BUnit[unit].import_mol(mol.get_atom_vect());
 backup_for_redo();

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 //表示
 if(!mol_cnt_before)
  slot_centering();

 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_add_peptide() {
 QInputDialog dialog(this);
 dialog.setLabelText("アミノ酸配列(2 < 残基数 < 11)");
 dialog.setInputMode(QInputDialog::TextInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 QString val = dialog.textValue();
 std::string seq = val.toStdString();
 int len = seq.size();
 if(len < 2) {
  QMessageBox::warning(this, "警告", "ペプチドではありません．");
  return;
 }
 if(!is_pept_seq(&seq)) {
  QMessageBox::warning(this, "警告", "アミノ酸コード以外の文字が含まれています．");
  return;
 }
 if(len > 10) {
  seq.resize(10);
  QMessageBox::warning(this, "警告", "鎖長が制限を超えていたので，先頭 10 アミノ酸に切り詰めました．");
 }

 int unit = get_curt_unit();
 backup_for_undo();

 //第一段階．骨格の生成
 Create_Pept_Bone pept;
 pept.create_pept_bone(&seq);

 BUnit[unit].import_mol(pept.get_atom_vect());

 //第二段階．変異
 std::vector<AA_Memo> aa_memo = *pept.get_aa_memo();
 //aa_memo の MolNum は仮の値が格納されているので修正
 int mol_cnt = BUnit[unit].get_mol_cnt();
 for(AA_Memo &aa : aa_memo)
  aa.MolNum = mol_cnt - 1;
 BUnit[unit].mutate(&aa_memo);

 backup_for_redo();

 //表示
 if(BUnit[unit].get_mol_cnt() == 1)
  slot_centering();

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 DrawSel[unit] = Draw_Selection::All;
 draw();
}

