#include "builcule_main.h"
#include "dialog_mm.h"
#include "dialog_conf.h"
#include "dialog_interaction.h"

void Builcule_Main::slot_minimum_all() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_mol_cnt())
  return;

 Dialog_MM *dialog_mm = new Dialog_MM(this);
// dialog_mm->setAttribute(Qt::WA_DeleteOnClose);
 if(dialog_mm->exec() == 0)  //Cancel ボタンをクリック
  return;

 const std::string *ff = dialog_mm->get_ff();
 const std::string *algo = dialog_mm->get_algorithm();
 double criteria = dialog_mm->get_criteria();
 int steps = dialog_mm->get_steps();
 if(criteria < 0 || steps < 0)
  return;

 backup_for_undo();
 BUnit[unit].energy_min_babel(
        ConfigFile.get_wk(), ff, algo, criteria, steps);
 backup_for_redo();
 repaint();
}

void Builcule_Main::slot_minimum_mol() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_mol_cnt())
  return;

 const std::vector<int> *mol
        = SelectorMol[unit].get_selected_idx();
 if(mol->empty()) {
  QMessageBox::warning(this, "警告",
        "分子が未選択です．");
 return;
 }

 Dialog_MM *dialog_mm = new Dialog_MM(this);
 //dialog_mm->setAttribute(Qt::WA_DeleteOnClose);
 if(dialog_mm->exec() == 0)  //Cancel ボタンをクリック
  return;

 const std::string *ff = dialog_mm->get_ff();
 const std::string *algo = dialog_mm->get_algorithm();
 double criteria = dialog_mm->get_criteria();
 int steps = dialog_mm->get_steps();
 if(criteria < 0 || steps < 0)
  return;

 backup_for_undo();
 BUnit[unit].energy_min_babel(
        ConfigFile.get_wk(), mol, ff, algo, criteria, steps);
 backup_for_redo();
 repaint();
}

void Builcule_Main::slot_conformation_all() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_mol_cnt())
  return;

 Dialog_Conf *dialog_conf = new Dialog_Conf(this);
// dialog_conf->setAttribute(Qt::WA_DeleteOnClose);
 if(dialog_conf->exec() == 0)  //Cancel ボタンをクリック
  return;

 const std::string *ff = dialog_conf->get_ff();
 const std::string *algo = dialog_conf->get_algorithm();
 double criteria = dialog_conf->get_criteria();
 int steps = dialog_conf->get_steps();
 int conf_cnt = dialog_conf->get_conf_cnt();
 int conf_steps = dialog_conf->get_conf_steps();
 if(criteria < 0.0 || steps < 0 || conf_cnt < 0 || conf_steps < 0)
  return;

 backup_for_undo();
 BUnit[unit].conf_search_babel(
        ConfigFile.get_wk(), ff, algo, criteria, steps, conf_cnt, conf_steps);
 backup_for_redo();

 repaint();
}

void Builcule_Main::slot_conformation_mol() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_mol_cnt())
  return;

 const std::vector<int> *mol
        = SelectorMol[unit].get_selected_idx();
 if(mol->empty()) {
  QMessageBox::warning(this, "警告",
        "分子が未選択です．");
 return;
 }

 Dialog_Conf *dialog_conf = new Dialog_Conf(this);
 //dialog_conf->setAttribute(Qt::WA_DeleteOnClose);
 if(dialog_conf->exec() == 0)  //Cancel ボタンをクリック
  return;

 const std::string *ff = dialog_conf->get_ff();
 const std::string *algo = dialog_conf->get_algorithm();
 double criteria = dialog_conf->get_criteria();
 int steps = dialog_conf->get_steps();
 int conf_cnt = dialog_conf->get_conf_cnt();
 int conf_steps = dialog_conf->get_conf_steps();
 if(criteria < 0.0 || steps < 0 || conf_cnt < 0 || conf_steps < 0)
  return;

 backup_for_undo();
 BUnit[unit].conf_search_babel(
    ConfigFile.get_wk(), mol, ff, algo, criteria, steps, conf_cnt, conf_steps);
 backup_for_redo();

 repaint();
}

void Builcule_Main::slot_homology() {
 if(BUnit[0].get_atom_cnt()) {
  QMessageBox::warning(this, "警告",
        "ユニット 0 は空にしてください．");
 return;
 }

 if(!BUnit[1].contain_peptide()) {
  QMessageBox::warning(this, "警告",
        "ユニット 1 ではタンパク質分子を開いてください．");
 return;
 }

 WinHM = new Window_HM(
    this, &BUnit[0], &BUnit[1], &ConfigFile, &WinSup);
 connect(WinHM, SIGNAL(hm_created()), this, SLOT(slot_after_hm()));
 WinHM->show();
}

void Builcule_Main::slot_after_hm() {  //変異の導入と表示
 slot_unit0();

 //変異．内容を書き換えるのでコピーを作成
 std::vector<AA_Memo> memo = *(WinHM->get_aa_memo());

 //変異を導入するアミノ酸を書き出しておいて，後でセレクタで選択
 std::array<int, 3> row0{0, 0, -1};
 std::vector<std::array<int, 3>> num0;
 for(const auto &row : memo) {
  if(row.Code != row.CodeTo) {
   row0[2] = row.SeqNum;
   num0.push_back(row0);
  }
 }

 BUnit[0].mutate(&memo);

 //情報の表示
 const auto mol_vect = BUnit[0].get_mol_vect();
 SelectorMol[0].create_list(mol_vect);

 const std::vector<std::vector<AA_Memo>> *aa_memo
        = BUnit[0].get_aa_memo();
 SelectorAA[0].clear_contents();
 SelectorAA[0].set_item(aa_memo);
 SelectorAA[0].select(&num0);

 int mol1 = WinHM->get_mol_u1();
 int pept1 = WinHM->get_pept_u1();
 int ini1 = WinHM->get_ini_u1();
 int ter1 = WinHM->get_ter_u1();
 std::array<int, 3> row{mol1, pept1, -1};
 std::vector<std::array<int, 3>> num;
 for(int i = ini1; i <= ter1; ++i) {
  row[2] = i;
  num.push_back(row);
 }
 SelectorAA[1].select(&num);

 //描画
 BUnit[0].calc_unit_center_radius();
 BUnit[0].init_rotation_center();
 BDraw[0].calc_eye_pos(
        BUnit[0].get_center(), BUnit[0].get_radius());
 slot_ball_stick();
}

void Builcule_Main::slot_adjust_structure() {
 int unit = get_curt_unit();
 const std::vector<int> *mol
        = SelectorMol[unit].get_selected_idx();
 if(mol->empty()) {
  QMessageBox::warning(this, "警告",
        "構造調整すべき分子を選択してください．");
  return;
 }

 backup_for_undo();

 BUnit[unit].adjust_structure(mol, ConfigFile.get_wk());

 backup_for_redo();
 repaint();
}

void Builcule_Main::slot_adjust_mol_pos() {
 int unit = get_curt_unit();
 int mol_cnt = BUnit[unit].get_mol_cnt();
 if(mol_cnt < 2) {
  QMessageBox::warning(this, "警告",
        "分子間の距離を調整するには 2 分子以上が必要です．");
  return;
 }

 backup_for_undo();

 BUnit[unit].adjust_mol_distance();

 slot_centering();
 backup_for_redo();
 repaint();
}

void Builcule_Main::slot_interaction() {
 int unit = get_curt_unit();
 int mol_cnt = BUnit[unit].get_mol_cnt();
 if(mol_cnt < 2) {
  QMessageBox::warning(this, "警告",
        "相互作用をシミュレートするには 2 分子以上が必要です．");
  return;
 }

 Dialog_Interaction dialog(this);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 int agg_step = dialog.get_aggregation_step();
 int int_step = dialog.get_interaction_step();
 if(!agg_step && !int_step)
  return;

 backup_for_undo();

 BUnit[unit].mol_interaction_pre(ConfigFile.get_wk());

 for(int i = 0; i != agg_step; ++i) {
  BUnit[unit].mol_aggregation(1);
  if(!(i % 1000)) {
   std::cerr << i << " steps" << std::endl;
   slot_centering();
   repaint();
  }
 }
 for(int i = 0; i != int_step; ++i) {
  BUnit[unit].mol_interaction(1);
  if(!(i % 1000)) {
   std::cerr << i << " steps" << std::endl;
   slot_centering();
   repaint();
  }
 }

 BUnit[unit].mol_interaction_after();

 slot_centering();
 backup_for_redo();
 repaint();
}

