#include "builcule_main.h"
#include "dialog_babel.h"
#include <QFileDialog>

void Builcule_Main::slot_open() {
 //ダイアログボックスの作成
 QFileDialog dialog(this);
 dialog.setNameFilter(
    "BCL, CIF, PDB, PDH, XYZ (*.bcl *.cif *.pdb  *.pdh *.xyz)");
 const std::string *file_dir = ConfigFile.get_dir_for_file();
 dialog.setDirectory(QString(file_dir->data()));
 dialog.setViewMode(QFileDialog::Detail);
 if(!dialog.exec())
  return;

 //ディレクトリ名を絶対パスで取得
 QDir qdir = dialog.directory();
 QString qdir_name = qdir.absolutePath();
 std::string dir_name = qdir_name.toStdString();
 ConfigFile.set_dir_for_file(&dir_name);

 //ファイル名を絶対パスで取得
 QStringList file_list = dialog.selectedFiles();
 QString qfile_name = file_list[0];
 std::string file_name = qfile_name.toStdString();
 //拡張子の取得
 std::filesystem::path full_path(file_name);
 std::string extension = full_path.extension();

 //ファイルを開く
 int unit = get_curt_unit();
 if(!BUnit[unit].open_unit(&file_name, &extension)) {
  QMessageBox::critical(this, "エラー", "ファイルを開けません．");
  return;
 }
 FileName[unit] = qfile_name;

 //表示
 DrawModel[unit] = Draw_Model::BallStick;
 DrawSel[unit] = Draw_Selection::All;

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_memo
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_memo);

 BUnit[unit].calc_unit_center_radius();
 BUnit[unit].init_rotation_center();

 BDraw[unit].clear_picked_obj();
 BDraw[unit].calc_eye_pos(
        BUnit[unit].get_center(), BUnit[unit].get_radius());

 slot_ball_stick();  //ここで描画
}

void Builcule_Main::slot_save() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 //ファイル選択ダイアログボックスの作成
 QFileDialog dialog(this);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 dialog.setNameFilter("BCL,PDB,XYZ (*.bcl *.pdb *.xyz)");
 const std::string *file_dir = ConfigFile.get_dir_for_file();
 dialog.setDirectory(QString(file_dir->data()));
 dialog.setViewMode(QFileDialog::Detail);
 if(!dialog.exec())
  return;

 //ディレクトリ名を絶対パスで取得
 QDir qdir = dialog.directory();
 QString qdir_name = qdir.absolutePath();
 std::string dir_name = qdir_name.toStdString();
 ConfigFile.set_dir_for_file(&dir_name);

 //ファイル名を絶対パスで取得
 QStringList file_list = dialog.selectedFiles();
 QString qfile_name = file_list[0];
 std::string file_name = qfile_name.toStdString();
 //拡張子の取得
 std::filesystem::path full_path(file_name);
 std::string extension = full_path.extension();

 //ファイルを保存
 if(!BUnit[unit].save_unit(&file_name, &extension))
  QMessageBox::critical(this, "エラー", "ファイル保存に失敗しました．");
}

void Builcule_Main::slot_export_fasta() {
 int unit = get_curt_unit();
 const std::vector<std::vector<AA_Memo>> *aa_memo
        = BUnit[unit].get_aa_memo();
 if(aa_memo->empty()) {
  QMessageBox::warning(this, "警告", "ペプチドが検知されていません．");
  return;
 }

 //ファイル選択ダイアログボックスの作成
 QFileDialog dialog(this);
 dialog.setAcceptMode(QFileDialog::AcceptSave);
 const std::string *file_dir = ConfigFile.get_dir_for_file();
 dialog.setDirectory(QString(file_dir->data()));
 dialog.setViewMode(QFileDialog::Detail);
 if(!dialog.exec())
  return;

 //ディレクトリ名を絶対パスで取得
 QDir qdir = dialog.directory();
 QString qdir_name = qdir.absolutePath();
 std::string dir_name = qdir_name.toStdString();
 ConfigFile.set_dir_for_file(&dir_name);

 //ファイル名を絶対パスで取得
 QStringList file_list = dialog.selectedFiles();
 QString qfile_name = file_list[0];
 std::string file_name = qfile_name.toStdString();

 //ファイルを保存
 if(!BUnit[unit].export_fasta(aa_memo, &file_name))
  QMessageBox::critical(this, "エラー", "ファイル保存に失敗しました．");
}

void Builcule_Main::slot_export_via_babel() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 //形式選択ダイアログを作成し，エクスポートするファイル形式を設定
 Dialog_Babel dialog1(this, false);
 if(dialog1.exec() == 0)  //Cancel ボタンをクリック
  return;
 //現状は，小文字，ドットなしの拡張子が得られる
 std::string target_ext = *dialog1.get_extention();
 if(target_ext.empty())
  return;

 //ファイル選択ダイアログを作成し，インポートするファイル名を取得
 QFileDialog dialog2(this);
 dialog2.setAcceptMode(QFileDialog::AcceptSave);
 const std::string *target_dir = ConfigFile.get_dir_for_file();
 dialog2.setDirectory(QString(target_dir->data()));
 //ファイル選択ダイアログ用のファイルフィルタ
 QString dialog_filter_0(target_ext.data());
 dialog_filter_0 += " 形式 (*.";
 dialog_filter_0 += target_ext.data();
 dialog_filter_0 += ")";
 const QStringList filters({dialog_filter_0, "他の拡張子 (*.*)"});
 dialog2.setNameFilters(filters);
 if(!dialog2.exec())  //enum QDialog::DialogCode が返る
  return;
 //ファイル名を絶対パスで取得
 QStringList file_list = dialog2.selectedFiles();
 QString qfile_path = file_list[0];
 QFile file(qfile_path);

 //拡張子とファイル形式がミスマッチの場合の処理
 //std::string curt_file_path = qfile_path.toStdString();
 QString q_target_ext = QString(target_ext.data());
 if(!match_ext_and_type(qfile_path, q_target_ext)) {
  //拡張子が不正確なら正しい拡張子を追加する
  qfile_path += '.';
  qfile_path += q_target_ext;
 }

 std::string target_file_path = qfile_path.toStdString();
 const std::string *wk = ConfigFile.get_wk();
 if(!BUnit[unit].export_via_babel(
        &target_file_path, &target_ext, wk))
  QMessageBox::critical(this, "エラー", "ファイルのエクスポート中にエラーが発生しました．");
}

bool Builcule_Main::match_ext_and_type(
        const QString &name, const QString &type) const {
 int cnt_name = name.count();  //フルパスの名前
 int cnt_suffix = type.count();  //拡張子（ドットなし）

 for(int i = 1; i <= cnt_suffix; ++i) {
  if(type[cnt_suffix - i] != name[cnt_name - i])
   return false;
 }

 if(name[cnt_name - cnt_suffix - 1] != '.')
  return false;

 return true;
}

void Builcule_Main::slot_import_via_babel() {
 //形式選択ダイアログを作成し，インポートするファイル形式を設定
 Dialog_Babel dialog1(this, true);
 if(dialog1.exec() == 0)  //Cancel ボタンをクリック
  return;
 //現状は，小文字，ドットなしの拡張子が得られる
 std::string target_ext = *dialog1.get_extention();
 if(target_ext.empty())
  return;

 //ファイル選択ダイアログを作成し，インポートするファイル名を取得
 QFileDialog dialog2(this);
 const std::string *target_dir = ConfigFile.get_dir_for_file();
 dialog2.setDirectory(QString(target_dir->data()));
 //ファイル選択ダイアログ用のファイルフィルタ
 QString qext(target_ext.data());
 qext += " 形式 (*.";
 qext += target_ext.data();
 qext += ")";
 const QStringList filters({qext, "他の拡張子 (*.*)"});
 dialog2.setNameFilters(filters);
 if(!dialog2.exec())  //enum QDialog::DialogCode が返る
  return;
 //ファイル名を絶対パスで取得
 QStringList file_list = dialog2.selectedFiles();
 QString qfile_path = file_list[0];
 QFile file(qfile_path);
 if (!file.open(QIODevice::ReadOnly)) {
  QMessageBox::critical(this, "エラー", "対象のファイルを開くことができません．");
  return;
 }
 std::string target_file = qfile_path.toStdString();

 //ファイルが格納されていたディレクトリを次に開くディレクトリとして設定
 QDir qdir = dialog2.directory();
 QString qdir_path = qdir.absolutePath();
 std::string dir_path = qdir_path.toStdString();
 ConfigFile.set_dir_for_file(target_dir);

 //OpenBabel 経由でインポート．open_unit とほぼ同じ
 int unit = get_curt_unit();
 const std::string *wk = ConfigFile.get_wk();
 if(!BUnit[unit].import_via_babel(
        &target_file, &target_ext, wk)) {
  QMessageBox::critical(this, "エラー", "ファイルを開けません．");
  return;
 }
 FileName[unit] = qfile_path;

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);

 const std::vector<std::vector<AA_Memo>> *aa_memo
        = BUnit[unit].get_aa_memo();

 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_memo);

 BUnit[unit].calc_unit_center_radius();
 BUnit[unit].init_rotation_center();

 BDraw[unit].clear_picked_obj();
 BDraw[unit].calc_eye_pos(
        BUnit[unit].get_center(), BUnit[unit].get_radius());

 slot_ball_stick();  //ここで描画
}

void Builcule_Main::slot_show_file_name() {
 int unit = get_curt_unit();
 QMessageBox::information(
        this, "直近に開いたファイル名", FileName[unit]);
}

