#include "builcule_main.h"
#include "dialog_mutate.h"

void Builcule_Main::slot_aa_selection_clear() {
 int unit = get_curt_unit();
 if(!SelectorAA[unit].get_row_cnt())
  return;
 if(DrawSel[unit] != Draw_Selection::AA)
  return;

 draw();
}

void Builcule_Main::slot_aa_selection_invert() {
 int unit = get_curt_unit();
 if(!SelectorAA[unit].get_row_cnt())
  return;
 if(DrawSel[unit] != Draw_Selection::AA)
  return;

 draw();
}

void Builcule_Main::slot_pick_to_aa() {
 int unit = get_curt_unit();
 if(!SelectorAA[unit].get_row_cnt())
  return;

 std::array<int, 3> ary;
 std::vector<std::array<int, 3>> vect;
 const std::vector<int> *picked = BDraw[unit].get_picked_serial();
 for(int serial : *picked) {
  int mol = BDraw[unit].get_mol_idx(serial);
  int pept = BDraw[unit].get_pept_idx(serial);
  int seq =BDraw[unit].get_seq_idx(serial);
  if(pept > -1) {
   ary = {mol, pept, seq};
   vect.push_back(ary);
  }
 }

 SelectorAA[unit].select(&vect);
}

void Builcule_Main::slot_aa_delete() {
 int unit = get_curt_unit();
 if(!SelectorAA[unit].get_row_cnt())
  return;

 const std::vector<AA_Memo> *aa_data
        = SelectorAA[unit].get_selected_aa_data();
 if(aa_data->empty()) {
  QMessageBox::warning(this, "警告", "アミノ酸が選択されていません．");
  return;
 }

 backup_for_undo();
 BUnit[unit].delete_aa(aa_data);
 BUnit[unit].detect_mol();
 backup_for_redo();

 //下記 create_list(mol_vect); 内の emit 先に何かがあってクリアが必要
 BDraw[unit].clear_picked_obj();   //正常終了

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_memo
        = BUnit[unit].get_aa_memo();

 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_memo);

 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_aa_mutate() {
 int unit = get_curt_unit();
 if(!SelectorAA[unit].get_row_cnt())
  return;

 //書き換えるコードを書いてみるのでコピーを作成．最終的に不要かも
 std::vector<AA_Memo> aa_memo
        = *SelectorAA[unit].get_selected_aa_data();

 if(aa_memo.empty()) {
  QMessageBox::warning(this, "警告", "アミノ酸が選択されていません．");
  return;
 }
 for(const AA_Memo &aam : aa_memo) {
  if(aam.Code == 'X') {
   QMessageBox::warning(this, "警告", "異常アミノ酸は変異できません．");
   return;
  }
 }

 Dialog_Mutate *dialog = new Dialog_Mutate(this);
 if(dialog->exec() == 0)  //Cancel ボタンをクリック
  return;

 char code_to = dialog->subst_code();
 for(AA_Memo &aa : aa_memo)
  aa.CodeTo = code_to;

 backup_for_undo();
 BUnit[unit].mutate(&aa_memo);  //構造調整していない
 backup_for_redo();

 const std::vector<std::vector<AA_Memo>> *new_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].set_item(new_data);

 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

