#include "builcule_main.h"

void Builcule_Main::slot_unit0() {
 RadioButtonUnit[0]->setChecked(true);
 slot_unit_changed();
}

void Builcule_Main::slot_unit1() {
 RadioButtonUnit[1]->setChecked(true);
 slot_unit_changed();
}

void Builcule_Main::slot_unit2() {
 RadioButtonUnit[2]->setChecked(true);
 slot_unit_changed();
}

void Builcule_Main::slot_pick_to_mol() {
 int unit = get_curt_unit();
 int mol_cnt = BUnit[unit].get_mol_cnt();
 if(!mol_cnt)
  return;

 std::vector<int> vect0(mol_cnt, 0);
 const std::vector<int> *picked = BDraw[unit].get_picked_serial();

 for(int serial : *picked) {
  int mol_idx = BDraw[unit].get_mol_idx(serial);
  //部分表示でピックされた原子が表示されていない場合は -1 が返る
  if(mol_idx > -1)
   vect0[mol_idx] = 1;
 }

 std::vector<int> vect1;
 for(int i = 0; i != mol_cnt; ++i) {
  if(vect0[i])
   vect1.push_back(i);
 }
 SelectorMol[unit].select(&vect1);
}

void Builcule_Main::slot_mol_copy() {
 int unit = get_curt_unit();
 if(!SelectorMol[unit].cnt())
  return;

 CopyMol.clear_mol_cpy();

 const auto *idx = SelectorMol[unit].get_selected_idx();
 int cnt = idx->size();
 for(int i = 0; i != cnt; ++i) {
  const auto *atom_vect = BUnit[unit].get_mol_atom((*idx)[i]);
  CopyMol.push_mol(atom_vect);
 }
}

void Builcule_Main::slot_mol_cut() {
 int unit = get_curt_unit();
 if(!SelectorMol[unit].cnt())
  return;

 const auto *idx = SelectorMol[unit].get_selected_idx();
 int cnt = idx->size();
 if(!cnt) {
  QMessageBox::warning(this, "警告", "分子を選択してください．");
  return;
 }

 //下記 create_list(mol_vect); 内の emit 先に何かがあってクリアが必要
 slot_clear_picked();

 slot_mol_copy();
 backup_for_undo();
 BUnit[unit].delete_mol(idx);
 backup_for_redo();

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 //表示
 DrawSel[unit] = Draw_Selection::All;
 slot_clear_picked();  //すべてのピックを解除すると，カットされた分子のピックも削除される
 draw();  //これを呼ばないと，カットされた分子が表示されたままになる
}

void Builcule_Main::slot_mol_paste() {
 int unit = get_curt_unit();
 int mol_cnt_before = BUnit[unit].get_mol_cnt();
 int cpy_mol_cnt = CopyMol.get_cpy_mol_cnt();
 if(!cpy_mol_cnt) {
  QMessageBox::warning(this, "警告", "コピーされた分子がありません．");
  return;
 }

 backup_for_undo();
 for(int i = 0; i != cpy_mol_cnt; ++i) {
  const std::vector<std::shared_ptr<Atom>> *atom_vect
        = CopyMol.get_mol(i);
  BUnit[unit].import_mol(atom_vect);
 }
 backup_for_redo();

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 //分子が1個の場合でも，マージの場合があるのでセンタリングしない

 DrawSel[unit] = Draw_Selection::All;
 draw();
}

