#include "builcule_main.h"
#include "window_align_3d.h"

void Builcule_Main::slot_centering() {
 int unit = get_curt_unit();
 BUnit[unit].centering();
 BDraw[unit].calc_eye_pos(
        BUnit[unit].get_center(), BUnit[unit].get_radius());
 BDraw[unit].repaint();
}

void Builcule_Main::slot_clear_picked() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 BDraw[unit].clear_picked_obj();
 BDraw[unit].repaint();
}

void Builcule_Main::slot_meas_dist() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 const std::vector<int> *picked = BDraw[unit].get_picked_serial();
 if(picked->size() != 2) {
  QMessageBox::warning(this, "警告", "2 原子をピックしてください．");
  return;
 }

 double distance = BDraw[unit].measure_distance();
 if(distance == 10.0)
  return;
 QString info(QString::number(distance));
 info += QString(" Å");
 QMessageBox::information(this, "距離", info);
}

void Builcule_Main::slot_meas_angle() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 const std::vector<int> *picked = BDraw[unit].get_picked_serial();
 if(picked->size() != 3) {
  QMessageBox::warning(this, "警告", "3 原子をピックしてください．");
  return;
 }

 double angle = BDraw[unit].measure_angle();
 if(angle == 10.0)
  return;
 QString info(QString::number(angle * RADtoDEG));
 info += QString(" °");
 QMessageBox::information(this, "度", info);
}

void Builcule_Main::slot_meas_dihead() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 const std::vector<int> *picked = BDraw[unit].get_picked_serial();
 if(picked->size() != 4) {
  QMessageBox::warning(this, "警告", "4 原子をピックしてください．");
  return;
 }

 double angle = BDraw[unit].measure_diheadral();
 if(angle == 10.0)
  return;
 QString info(QString::number(angle * RADtoDEG));
 info += QString(" °");
 QMessageBox::information(this, "度", info);
}

void Builcule_Main::slot_alter_length_mouse() {
 if(!select_region(2))
  return;

 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 BUnit[unit].set_region_direction((*serial)[0], (*serial)[1]);
 BDraw[unit].set_affine_trans(Affine_Trans::REGION_MOVE);
}

void Builcule_Main::slot_alter_angle_mouse() {
 if(!select_region(3))
  return;

 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 BUnit[unit].set_region_center_axis(
        (*serial)[0], (*serial)[1], (*serial)[2]);
 BDraw[unit].set_affine_trans(Affine_Trans::REGION_ROTATE);
}

void Builcule_Main::slot_alter_dihead_mouse() {
 if(!select_region(4))
  return;

 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 BUnit[unit].set_region_center_axis((*serial)[1], (*serial)[2]);
 BDraw[unit].set_affine_trans(Affine_Trans::REGION_ROTATE);
}

void Builcule_Main::slot_move_selected() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 //回転用に第一選択分子，平行移動用に選択分子を設定する
 if(SelectorMol[unit].first_selected_idx() < 0) {
  QMessageBox::warning(this, "警告", "分子を選択してください．");
  return;
 }

 const std::vector<int> *idx =
        SelectorMol[unit].get_selected_idx();
 BUnit[unit].set_mol_idx_for_rotation(idx);
 BDraw[unit].set_affine_trans(Affine_Trans::MOL);
}

void Builcule_Main::slot_pick_super() {
 const std::vector<int> *pick0 = BDraw[0].get_picked_serial();
 const std::vector<int> *pick1 = BDraw[1].get_picked_serial();
 int cnt0 = pick0->size();
 int cnt1 = pick1->size();
 if(cnt0 != cnt1) {
  QMessageBox::warning(this, "警告",
        "ユニット 0 とユニット 1 でのピック数が異なります．");
  return;
 }
 if(!cnt0) {
  QMessageBox::warning(this, "警告",
        "ユニット 0 とユニット 1 で，重ね合わせたい原子をピックしてください．");
  return;
 }

 if(cnt0 > 3) {
  sup_pick_by_matrix(pick0, pick1);
  slot_show_sup_win();
  return;
 }

 //1 原子めは無条件．2 原子め以降の回転の中心となる
 const auto &atom00 = BUnit[0].get_atom((*pick0)[0]);
 const auto &atom10 = BUnit[1].get_atom((*pick1)[0]);
 const auto *v00 = atom00->get_xyz();
 const auto *v10 = atom10->get_xyz();
 Eigen::Vector3d v = *v10 - *v00;
 const auto *atom_vect = BUnit[0].get_atom_vect();
 for(const auto &atom : *atom_vect) {
  auto *xyz = atom->get_xyz();
  *xyz += v;
 }
 if(cnt0 == 1) {
  slot_show_sup_win();
  return;
 }

 //2 原子め
 const auto &atom01 = BUnit[0].get_atom((*pick0)[1]);
 const auto &atom11 = BUnit[1].get_atom((*pick1)[1]);
 const auto *v01 = atom01->get_xyz();
 const auto *v11 = atom11->get_xyz();
 Rotate_Point rotate;
 rotate.set_center(v10);
 if(!rotate.set_axis(v01, v10, v11)) {
  QMessageBox::critical(this, "エラー", "回転軸の作成に失敗しました．");
  return;
 }
 double radian2 = measure_angle(v01, v10, v11) / 2.0;
 for(const auto &atom : *atom_vect) {
  auto *xyz = atom->get_xyz();
  rotate.rotate(xyz, radian2);
 }
 if(cnt0 == 2) {
  slot_show_sup_win();
  return;
 }

 //3 原子め
 rotate.set_axis(v10, v11); //回転軸の変更

 const auto &atom02 = BUnit[0].get_atom((*pick0)[2]);
 const auto &atom12 = BUnit[1].get_atom((*pick1)[2]);
 const auto *v02 = atom02->get_xyz();
 const auto *v12 = atom12->get_xyz();
 radian2 = measure_diheadral(v02, v01, v10, v12) / 2.0;
 for(const auto &atom : *atom_vect) {
  auto *xyz = atom->get_xyz();
  rotate.rotate(xyz, radian2);
 }
 slot_show_sup_win();
}

void Builcule_Main::sup_pick_by_matrix(
    const std::vector<int> *pick0, const std::vector<int> *pick1) {
 std::vector<std::shared_ptr<Atom>> atom_vect0;
 for(int serial : *pick0)
  atom_vect0.push_back(BUnit[0].get_atom(serial));

 std::vector<std::shared_ptr<Atom>> atom_vect1;
 for(int serial : *pick1)
  atom_vect1.push_back(BUnit[1].get_atom(serial));

 Sup_3D sup;
 sup.set_pos_vect(0, &atom_vect0);
 sup.set_pos_vect(1, &atom_vect1);
 if(!sup.create_rotation_matrix()) {
  QMessageBox::critical(this, "エラー", "回転行列が作成できません．");
  return;
 }
 const auto *atom_vect = BUnit[0].get_atom_vect();
 for(const auto &atom : *atom_vect) {
  auto *xyz = atom->get_xyz();
  sup.rotate(xyz);
 }
}

void Builcule_Main::slot_seq_super() {
 if(!BUnit[0].contain_peptide()) {
  QMessageBox::warning(this, "警告",
        "ユニット 0 ではタンパク質分子を開いてください．");
 return;
 }
 if(!BUnit[1].contain_peptide()) {
  QMessageBox::warning(this, "警告",
        "ユニット 1 ではタンパク質分子を開いてください．");
 return;
 }

 Window_Align_3D *align = new Window_Align_3D(
    this, &BUnit[0], &BUnit[1], &ConfigFile, &WinSup);
 align->show();
}

