#include "builcule_main.h"
#include "dialog_elmt.h"
#include "dialog_elong.h"
#include "dialog_hydrogen.h"
#include "dialog_subst.h"

void Builcule_Main::slot_change_element() {
 int unit = get_curt_unit();
 const std::vector<int> *picked_serial
        = BDraw[unit].get_picked_serial();
 if(picked_serial->empty()) {
  QMessageBox::warning(this, "警告", "変更すべき原子をピックしてください．");
  return;
 }

 Dialog_Elmt dialog(this);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 int elmt = dialog.selected_elmt();

 backup_for_undo();
 BUnit[unit].change_elmt(picked_serial, elmt);
 backup_for_redo();
 BDraw[unit].change_elmt(elmt);

 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);
 slot_clear_picked();
 draw();
}

void Builcule_Main::slot_delete_atom() {
 int unit = get_curt_unit();
 const auto *serial = BDraw[unit].get_picked_serial();
 if(!serial->size()) {
  QMessageBox::warning(this, "警告", "原子をピックしてください．");
  return;
 }

 backup_for_undo();
 BUnit[unit].delete_atom(serial);
 backup_for_redo();
 BUnit[unit].detect_mol();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_create_bond() {
 int unit = get_curt_unit();
 const auto *serial = BDraw[unit].get_picked_serial();
 if(serial->size() != 2) {
  QMessageBox::warning(this, "警告", "2 原子をピックしてください．");
  return;
 }

 int serial0 = (*serial)[0];
 int serial1 = (*serial)[1];
 if(BUnit[unit].is_bound(serial0, serial1)) {
  QMessageBox::warning(this, "警告", "すでに結合しています．");
  return;
 }

 backup_for_undo();
 BUnit[unit].create_bond(serial0, serial1);
 backup_for_redo();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);
 BDraw[unit].clear_picked_obj();
 draw();
}

void Builcule_Main::slot_delete_bond() {
 int unit = get_curt_unit();
 const auto *serial = BDraw[unit].get_picked_serial();
 if(serial->size() != 2) {
  QMessageBox::warning(this, "警告", "2 原子をピックしてください．");
  return;
 }

 int serial0 = (*serial)[0];
 int serial1 = (*serial)[1];
 if(!BUnit[unit].is_bound(serial0, serial1)) {
  QMessageBox::warning(this, "警告", "もともと結合していません．");
 }

 backup_for_undo();
 BUnit[unit].delete_bond(serial0, serial1);
 backup_for_redo();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);
 BDraw[unit].clear_picked_obj();
 draw();
}

void Builcule_Main::slot_elongation() {
 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 if(serial->empty()) {
  QMessageBox::warning(this, "警告", "変更すべき原子をピックしてください．");
  return;
 }

 Dialog_Elong dialog(this);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 int elmt = dialog.selected_elmt();
 Orbital orbital = dialog.get_selected_orbital();

 backup_for_undo();

 int err_cnt = BUnit[unit].elongation(serial, elmt, orbital);
 if(err_cnt) {
  QString msg(QString::number(err_cnt));
  msg += " 個の伸長/分岐ができませんでした．";
  QMessageBox::warning(this, "警告", msg);
 }

 backup_for_redo();

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

bool Builcule_Main::slot_region_copy() {
 if(!select_region(2))
  return false;

 int unit = get_curt_unit();
 const auto &region_vect = BUnit[unit].get_region();
 const auto &root_atom = BUnit[unit].get_region_root();
 CopyRegion.import_region(root_atom, region_vect);

 BDraw[unit].clear_picked_obj();
 draw();
 return true;
}

void Builcule_Main::slot_region_cut() {
 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 if(serial->size() != 2) {
  QMessageBox::warning(this, "警告", "2 原子をピックしてください．");
  return;
 }

 slot_region_copy();
 backup_for_undo();
 BUnit[unit].delete_region();
 backup_for_redo();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_region_connect() {
 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 if(serial->empty()) {
  QMessageBox::warning(this, "警告", "変更すべき原子をピックしてください．");
  return;
 }

 if(CopyRegion.region_is_empty()) {
  QMessageBox::warning(this, "警告", "コピーされた領域がありません．");
  return;
 }

 backup_for_undo();
 int picked_cnt = serial->size();
 const auto subst = CopyRegion.export_region(picked_cnt);
 int err_cnt = BUnit[unit].connect_subst(serial, subst);
 if(err_cnt) {
  QString msg(QString::number(err_cnt));
  msg += " 個の接続ができませんでした．";
  QMessageBox::warning(this, "警告", msg);
 }
 backup_for_redo();

 //表示
 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_substitute() {
 int unit = get_curt_unit();
 const std::vector<int> *serial = BDraw[unit].get_picked_serial();
 if(serial->empty()) {
  QMessageBox::warning(this, "警告", "変更すべき原子をピックしてください．");
  return;
 }

 const auto name = Subst.get_subst_name();
 if(name->empty()) {
  QMessageBox::warning(this, "警告", "置換基が作成されていません．");
  return;
 }

 Dialog_Subst dialog(this, name);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 int subst_idx = dialog.get_subst_idx();

 backup_for_undo();

 int picked_cnt = serial->size();
 const auto subst = Subst.export_subst(subst_idx, picked_cnt);
 int err_cnt = BUnit[unit].connect_subst(serial, subst);
 if(err_cnt) {
  QString msg(QString::number(err_cnt));
  msg += " 個の接続ができませんでした．";
  QMessageBox::warning(this, "警告", msg);
 }

 backup_for_redo();

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 const std::vector<std::vector<AA_Memo>> *aa_data
        = BUnit[unit].get_aa_memo();
 SelectorAA[unit].clear_contents();
 SelectorAA[unit].set_item(aa_data);

 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_add_hydrogen() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 Dialog_Hydrogen dialog(this, true);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 int select = dialog.get_selected_button();
 double pH = 0.0;
 if(select == 1)
  pH = dialog.get_ph();

 bool result = true;
 switch(select) {
  case 0:
   BUnit[unit].add_peptide_H();
   break;
  case 1:
   result =
        BUnit[unit].add_H_babel(ConfigFile.get_wk(), 0, pH);
   break;
  case 2:
   result =
        BUnit[unit].add_H_babel(ConfigFile.get_wk(), 1);
   break;
  case 3:
   result =
        BUnit[unit].add_H_babel(ConfigFile.get_wk(), 2);
   break;
  default:
   break;
 }

 if(!result) {
  QMessageBox::critical(this, "エラー", "失敗しました．");
  return;
 }

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_delete_hydrogen() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 Dialog_Hydrogen dialog(this, false);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;

 int select = dialog.get_selected_button();

 bool result = true;
 switch(select) {
  case 0:
   BUnit[unit].delete_peptide_H();
   break;
  case 1:
   result =
        BUnit[unit].delete_H_babel(ConfigFile.get_wk(), 0);
   break;
  case 2:
   result =
        BUnit[unit].delete_H_babel(ConfigFile.get_wk(), 1);
   break;
  case 3:
   result =
        BUnit[unit].delete_H_babel(ConfigFile.get_wk(), 2);
   break;
  default:
   break;
 }

 if(!result) {
  QMessageBox::critical(this, "エラー", "失敗しました．");
  return;
 }

 const auto mol_vect = BUnit[unit].get_mol_vect();
 SelectorMol[unit].create_list(mol_vect);
 SelectorMol[unit].restore_old_selection();
 BDraw[unit].clear_picked_obj();
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_clear_unit() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 backup_for_undo();

 BUnit[unit].clear();
 BDraw[unit].clear_picked_obj();
 BDraw[unit].clear_obj();
 BDraw[unit].repaint();
 SelectorMol[unit].clear();
 SelectorAA[unit].clear_contents();
}

