#include "builcule_main.h"

void Builcule_Main::slot_ball_stick() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 DrawModel[unit] = Draw_Model::BallStick;
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_waals() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 DrawModel[unit] = Draw_Model::Spacefill;
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_wire() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 DrawModel[unit] = Draw_Model::Wireframe;
 DrawSel[unit] = Draw_Selection::All;
 draw();
}

void Builcule_Main::slot_show_sup_win() {
 if(!BUnit[1].get_atom_cnt() || !BUnit[1].get_atom_cnt()) {
  QMessageBox::warning(this, "警告", "ユニット 0 と 1 で分子を作成してください．");
  return;
 }

 WinSup.show();
 WinSup.set_view_pos(1);
 WinSup.push_wire();
 //WinSup.draw();  //WinSup.push_wire() で描画される
}

void Builcule_Main::slot_selected_mol_ball() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 const auto *mol_idx = SelectorMol[unit].get_selected_idx();
 BUnit[unit].check_mol_atom(mol_idx);

 DrawModel[unit] = Draw_Model::BallStick;
 DrawSel[unit] = Draw_Selection::Mol;
 draw();
}

void Builcule_Main::slot_selected_mol_waals() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 const auto *mol_idx = SelectorMol[unit].get_selected_idx();
 BUnit[unit].check_mol_atom(mol_idx);

 DrawModel[unit] = Draw_Model::Spacefill;
 DrawSel[unit] = Draw_Selection::Mol;
 draw();
}

void Builcule_Main::slot_selected_aa_ball() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 DrawModel[unit] = Draw_Model::BallStick;
 DrawSel[unit] = Draw_Selection::AA;
 draw();
}

void Builcule_Main::slot_selected_aa_waals() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 DrawModel[unit] = Draw_Model::Spacefill;
 DrawSel[unit] = Draw_Selection::AA;
 draw();
}

void Builcule_Main::slot_pick_to_neighbor() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 QInputDialog dialog(this);
 dialog.setDoubleDecimals(2);
 dialog.setDoubleRange(0.0, 10.0);
 dialog.setLabelText("範囲(0.0 〜 10.0)");
 dialog.setInputMode(QInputDialog::DoubleInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double thres = dialog.doubleValue();

 const auto *serial = BDraw[unit].get_picked_serial();
 const auto *aa = BUnit[unit].detect_neighbor_atom_from_atom(serial, thres);
 SelectorAA[unit].select(aa);
 DrawSel[unit] = Draw_Selection::Atom;
 draw();
}

void Builcule_Main::slot_mol_to_neighbor() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 QInputDialog dialog(this);
 dialog.setDoubleDecimals(2);
 dialog.setDoubleRange(0.0, 10.0);
 dialog.setLabelText("範囲(0.0 〜 10.0)");
 dialog.setInputMode(QInputDialog::DoubleInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double thres = dialog.doubleValue();
 const auto *idx = SelectorMol[unit].get_selected_idx();
 const auto *aa = BUnit[unit].detect_neighbor_atom_from_mol(idx, thres);

 SelectorAA[unit].select(aa);
 DrawSel[unit] = Draw_Selection::Atom;
 draw();
}

void Builcule_Main::slot_aa_to_neighbor() {
 int unit = get_curt_unit();
 if(!BUnit[unit].get_atom_cnt())
  return;

 QInputDialog dialog(this);
 dialog.setDoubleDecimals(2);
 dialog.setDoubleRange(0.0, 10.0);
 dialog.setLabelText("範囲(0.0 〜 10.0)");
 dialog.setInputMode(QInputDialog::DoubleInput);
 if(!dialog.exec())  //enum QDialog::DialogCode が返る
  return;
 double thres = dialog.doubleValue();

 const auto *aa_data = SelectorAA[unit].get_selected_aa_data();
 const auto *aa = BUnit[unit].detect_neighbor_atom_from_aa(aa_data, thres);
 SelectorAA[unit].select(aa);
 DrawSel[unit] = Draw_Selection::Atom;
 draw();
}

