#include "dialog_conf.h"
#include <QValidator>

Dialog_Conf::Dialog_Conf(QWidget *parent)
 : Dialog_MM(parent),
   ConfCnt(250),
   ConfSteps(100)
{
 //メインウィンドウ
 setWindowTitle("OpenBabel によるコンフォメーション探索");
 setFixedSize(400, 670);

 //コンフォーマー発生数
 QLabel *label_conf_cnt
        = new QLabel("コンフォーマー数（1〜999）", this);
 CentralLayout->addWidget(label_conf_cnt);
 LeConfCnt
        = new QLineEdit(QString::number(ConfCnt), CentralWidget);
 QValidator *val_conf = new QIntValidator(1, 999, this);
 LeConfCnt->setValidator(val_conf);
 CentralLayout->addWidget(LeConfCnt);

 //コンフォーマーステップ数
 QLabel *label_conf_steps
        = new QLabel("コンフォーマーステップ数（1〜999）", this);
 CentralLayout->addWidget(label_conf_steps);
 LeConfSteps
        = new QLineEdit(QString::number(ConfSteps), CentralWidget);
 LeConfCnt->setValidator(val_conf);
 CentralLayout->addWidget(LeConfSteps);
}

int Dialog_Conf::get_conf_cnt() {
 int val = -1;

 QString str = LeConfCnt->text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "コンフォーマー発生数が空欄です．");
  return -1;
 }
 val = str.toInt();

 return val;
}

int Dialog_Conf::get_conf_steps() {
 int val = -1;

 QString str = LeConfSteps->text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "コンフォーマーステップ数が空欄です．");
  return -1;
 }
 val = str.toInt();

 return val;
}

