#include "dialog_elmt.h"

Dialog_Elmt::Dialog_Elmt(QWidget *parent)
 : QDialog(parent),
   WidgetPeriodic(nullptr)
{
 setModal(true);
 setWindowTitle("元素の変更");
 setFixedSize(1050, 450);

 QWidget *central_widget = new QWidget(this);
 QVBoxLayout *central_layout = new QVBoxLayout(central_widget);
 central_widget->setLayout(central_layout);

 WidgetPeriodic = new Widget_Periodic(central_widget);
 central_layout->addWidget(WidgetPeriodic);

 QWidget *button_widget = new QWidget(central_widget);
 QHBoxLayout *button_layout = new QHBoxLayout(button_widget);
 central_layout->addWidget(button_widget);

 //下記 connect で，OK をクリックしたときにのみ値が取得できるようになる
 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 button_layout->addWidget(cancel_button, Qt::AlignRight);
 connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 button_layout->addWidget(ok_button);
 button_layout->setAlignment(Qt::AlignRight);
 connect(ok_button, SIGNAL(clicked()), this, SLOT(accept()));
}

