#include "dialog_elong.h"
#include <QRadioButton>

Dialog_Elong::Dialog_Elong(QWidget *parent)
 : QDialog(parent),
   WidgetPeriodic(nullptr)
{
 setModal(true);
 setWindowTitle("元素の変更");
 setFixedSize(1050, 500);

 //ウィジェットを縦並びに配置
 QWidget *central_widget = new QWidget(this);
 QVBoxLayout *central_layout = new QVBoxLayout(central_widget);
 central_widget->setLayout(central_layout);

 //周期表
 WidgetPeriodic = new Widget_Periodic(central_widget);
 central_layout->addWidget(WidgetPeriodic);
 central_layout->setContentsMargins(10, 10, 0, 10);

 //軌道と OK/Cancel ボタンを，周期表の下に，横並びに配置
 QWidget *orb_ok_widget = new QWidget(central_widget);
 QHBoxLayout *orb_ok_layout = new QHBoxLayout(orb_ok_widget);
 central_layout->addWidget(orb_ok_widget);
 orb_ok_layout->setContentsMargins(10, 0, 10, 10);

 QWidget *orbital_widget = new QWidget(orb_ok_widget);
 QVBoxLayout *orbital_layout = new QVBoxLayout(orbital_widget);
 orb_ok_layout->addWidget(orbital_widget);

 OrbitalGroup = new QButtonGroup(orbital_widget);
 std::array<QRadioButton *, 3> orbital_array;
 for(int i = 0; i < 3; ++i) {
  orbital_array[i] = new QRadioButton(orbital_widget);
  orbital_layout->addWidget(orbital_array[i]);
  OrbitalGroup->addButton(orbital_array[i], i);
 }
 orbital_array[0]->setText("sp3");
 orbital_array[0]->setChecked(true);
 orbital_array[1]->setText("sp2");
 orbital_array[2]->setText("sp");

 QWidget *ok_widget = new QWidget(orb_ok_widget);
 QHBoxLayout *ok_layout = new QHBoxLayout(ok_widget);
 orb_ok_layout->addWidget(ok_widget);

 //下記 connect で，OK をクリックしたときにのみ値が取得できるようになる
 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 ok_layout->addWidget(cancel_button, Qt::AlignRight);
 connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 ok_layout->addWidget(ok_button);
 ok_layout->setAlignment(Qt::AlignRight);
 connect(ok_button, SIGNAL(clicked()), this, SLOT(accept()));
}


Orbital Dialog_Elong::get_selected_orbital() const {
 int id = OrbitalGroup->checkedId();
 if(id == 0)
  return Orbital::SP3;
 else if(id == 1)
  return Orbital::SP2;
 else if(id == 2)
  return Orbital::SP;
 else
  return Orbital::Default;
}
