#include "dialog_hydrogen.h"
#include <QBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QValidator>
#include <iostream>
Dialog_Hydrogen::Dialog_Hydrogen(
        QWidget *parent, bool add)
 : QDialog(parent)
{
 setModal(true);
 setWindowTitle("水素除去");

 QWidget *central_widget = new QWidget(this);
 QVBoxLayout *central_layout = new QVBoxLayout(central_widget);
 central_widget->setLayout(central_layout);

 ButtonArray[0] = new QRadioButton(this);
 if(add)
  ButtonArray[0]->setText("ペプチドに水素付加(Builcule)");
 else
  ButtonArray[0]->setText("ペプチドから水素除去(Builcule)");
 ButtonGroup.addButton(ButtonArray[0], 0);
 central_layout->addWidget(ButtonArray[0]);

 ButtonArray[1] = new QRadioButton(this);
 if(add)
  ButtonArray[1]->setText("水素付加(OpenBabel)；pH依存");
 else
  ButtonArray[1]->setText("水素除去(OpenBabel)");
 ButtonGroup.addButton(ButtonArray[1], 1);
 central_layout->addWidget(ButtonArray[1]);

 ButtonArray[2] = new QRadioButton(this);
 if(add)
  ButtonArray[2]->setText("極性水素付加(OpenBabel)");
 else
  ButtonArray[2]->setText("極性水素除去(OpenBabel)");
 ButtonGroup.addButton(ButtonArray[2], 2);
 central_layout->addWidget(ButtonArray[2]);

 ButtonArray[3] = new QRadioButton(this);
 if(add)
  ButtonArray[3]->setText("非極性水素付加(OpenBabel)");
 else
  ButtonArray[3]->setText("非極性水素除去(OpenBabel)");
 ButtonGroup.addButton(ButtonArray[3], 3);
 central_layout->addWidget(ButtonArray[3]);

 ButtonArray[0]->setChecked(true);

 //水素付加用のダイアログボックスとする場合
 if(add) {
  setFixedSize(260, 240);
  QWidget *widget_ph = new QWidget(this);
  QHBoxLayout *layout_ph = new QHBoxLayout(widget_ph);
  widget_ph->setLayout(layout_ph);
  QLabel *label_ph = new QLabel(widget_ph);
  label_ph->setText("pH : ");
  layout_ph->addWidget(label_ph);
  LineEditPH = new QLineEdit(widget_ph);
  QValidator *val_ph = new QDoubleValidator(1.0, 14.0, 1, this);
  LineEditPH->setValidator(val_ph);
  layout_ph->addWidget(LineEditPH);
  central_layout->addWidget(widget_ph);
 }
 else
  setFixedSize(260, 190);

 QWidget *button_widget = new QWidget(central_widget);
 QHBoxLayout *button_layout = new QHBoxLayout(button_widget);
 central_layout->addWidget(button_widget);

 //下記 connect で，OK をクリックしたときにのみ値が取得できるようになる
 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 button_layout->addWidget(cancel_button, Qt::AlignRight);
 connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 button_layout->addWidget(ok_button);
 button_layout->setAlignment(Qt::AlignRight);
 connect(ok_button, SIGNAL(clicked()), this, SLOT(accept()));
}

double Dialog_Hydrogen::get_ph() {
 double pH = 7.4;

 QString str = LineEditPH->text();
 if(str.isEmpty())
  pH = 7.4;
 pH = str.toDouble();
 //Validator が機能しない
 if(pH < 1.0 || 14.0 < pH)
  pH = 7.4;

 return pH;
}

