#include "dialog_interaction.h"
#include <QGridLayout>
#include <QIntValidator>
#include <QLabel>
#include <QPushButton>

Dialog_Interaction::Dialog_Interaction(QWidget *parent)
 : QDialog(parent),
   AggregationStep(0),
   InteractionStep(0) {
 //ウィンドウのレイアウト
 setModal(true);
 setWindowTitle("分子間の相互作用モデルを生成します");
 setFixedSize(450, 130);

 QWidget *central_widget = new QWidget(this);
 QGridLayout *CentralLayout = new QGridLayout(this);
 central_widget->setLayout(CentralLayout);
 CentralLayout->setContentsMargins(10, 10, 10, 10);

 //凝集過程の設定
 QLabel * label_aggregation = new QLabel(
        "凝集過程のステップ(0〜1000000)", central_widget);
 CentralLayout->addWidget(label_aggregation, 0, 0);

 LeAggregation = new QLineEdit(this);
 QValidator *validator = new QIntValidator(1, 1000000, this);
 LeAggregation->setValidator(validator);

 CentralLayout->addWidget(LeAggregation, 0, 1);

 //相互作用過程の設定
 QLabel * label_interaction = new QLabel(
        "相互作用過程のステップ(0〜1000000)", central_widget);
 CentralLayout->addWidget(label_interaction, 1, 0);

 LeInteraction = new QLineEdit(this);
 LeInteraction->setValidator(validator);

 CentralLayout->addWidget(LeInteraction, 1, 1);

 //OK/Cancel ボタンを配置する
 QWidget *ok_widget = new QWidget(this);
 CentralLayout->addWidget(ok_widget);
 QHBoxLayout *ok_layout = new QHBoxLayout(ok_widget);

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 connect(ok_button,
        SIGNAL(clicked()),
        this,
        SLOT(slot_ok_button_clicked()));
 ok_layout->addWidget(ok_button);
 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 connect(cancel_button,
        SIGNAL(clicked()),
        this,
        SLOT(reject()));
 ok_layout->addWidget(cancel_button);
}

void Dialog_Interaction::slot_ok_button_clicked() {
 QString str = LeAggregation->text();
 AggregationStep = str.toInt();

 str = LeInteraction->text();
 InteractionStep = str.toInt();
 accept();
}

