#include "dialog_mm.h"
#include <QValidator>

Dialog_MM::Dialog_MM(QWidget *parent)
 : QDialog(parent),
   FF("MMFF94"),
   Algo("-cg"),
   Criteria(1e-06),
   Steps(2500)
{
 //力場ボタンのラベル
 const int ff_cnt = 4;
 std::array<std::string, ff_cnt> ff_label;
 ff_label[0] = "MMFF94（有機分子向き）";
 ff_label[1] = "GAFF（有機分子向き）";
 ff_label[2] = "UFF（他の分子向き）";
 ff_label[3] = "Ghamical";

 //アルゴリズムボタンのラベル
 const int algo_cnt = 2;
 std::array<std::string, algo_cnt> algo_label;
 algo_label[0] = "共役勾配法";
 algo_label[1] = "最急降下法";

 //メインウィンドウ
 setModal(true);
 setWindowTitle("OpenBabel によるエネルギー極小化");
 setFixedSize(400, 550);

 CentralWidget = new QWidget(this);
 CentralLayout = new QVBoxLayout(CentralWidget);

 //スタート / キャンセル ボタン
 QWidget *start_widget = new QWidget(CentralWidget);
 QHBoxLayout *start_layout = new QHBoxLayout(start_widget);
 CentralLayout->addWidget(start_widget);

 QPushButton *start_button = new QPushButton("開始", CentralWidget);
 start_button->setFixedSize(80, 30);
 connect(start_button, SIGNAL(clicked()), this, SLOT(accept()));
 start_layout->addWidget(start_button);

 QPushButton *cancel_button = new QPushButton("キャンセル", CentralWidget);
 cancel_button->setFixedSize(80, 30);
 connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));
 start_layout->addWidget(cancel_button);

 QLabel *label_abb = new QLabel("力場と極小値探索アルゴリズムの組み合わによっては\n異常終了する場合があります.\n");
 CentralLayout->addWidget(label_abb);

 //力場の選択
 QLabel *label_ff = new QLabel("力場の選択", this);
 CentralLayout->addWidget(label_ff);
 QWidget *ff_widget = new QWidget(CentralWidget);
 QVBoxLayout *ff_layout = new QVBoxLayout(ff_widget);
 CentralLayout->addWidget(ff_widget);

 FFGroup = new QButtonGroup(this);
 std::array<QRadioButton *, ff_cnt> ff_buttons;
 for(int i = 0; i < ff_cnt; ++i) {
  ff_buttons[i] = new QRadioButton(ff_label[i].data(), this);
  ff_layout->addWidget(ff_buttons[i]);
  FFGroup->addButton(ff_buttons[i], i);
 }

 ff_buttons[0]->setChecked(true);
 connect(FFGroup, SIGNAL(buttonClicked(int)), this, SLOT(slot_ff_button_clicked()));

 //アルゴリズムの選択
 QLabel *label_algo = new QLabel("極小値探索アルゴリズムの選択", this);
 CentralLayout->addWidget(label_algo);
 QWidget *algo_widget = new QWidget(CentralWidget);
 QVBoxLayout *algo_layout = new QVBoxLayout(algo_widget);
 CentralLayout->addWidget(algo_widget);

 AlgoGroup = new QButtonGroup(this);
 std::array<QRadioButton *, algo_cnt> algo_buttons;
 for(int i = 0; i < algo_cnt; ++i) {
  algo_buttons[i] = new QRadioButton(algo_label[i].data(), this);
  algo_layout->addWidget(algo_buttons[i]);
  AlgoGroup->addButton(algo_buttons[i], i);
 }
 algo_buttons[0]->setChecked(true);
 connect(AlgoGroup, SIGNAL(buttonClicked(int)), this, SLOT(slot_algo_button_clicked()));

 //収束条件の設定
 QLabel *label_criteria = new QLabel("収束条件を指数で設定\n（1e-07 〜 1e-04 で設定可能にしています）", this);
 CentralLayout->addWidget(label_criteria);
 LeCriteria
        = new QLineEdit(QString::number(Criteria), CentralWidget);
 LeCriteria->setMaxLength(5);
 CentralLayout->addWidget(LeCriteria);

 //ステップ数
 QLabel *label_steps = new QLabel("ステップ数（1〜9999）", this);
 CentralLayout->addWidget(label_steps);
 LeSteps = new QLineEdit(QString::number(Steps), CentralWidget);

 QValidator *val_step = new QIntValidator(1, 9999, this);
 LeSteps->setValidator(val_step);
 CentralLayout->addWidget(LeSteps);
}

void Dialog_MM::slot_ff_button_clicked() {
 int button_num = FFGroup->checkedId();
 if(button_num == 0)
  FF = "MMFF94";
 else if(button_num == 1)
  FF = "GAFF";
 else if(button_num == 2)
  FF = "UFF";
 else
  FF = "Ghemical";
}
void Dialog_MM::slot_algo_button_clicked() {
 int button_num = AlgoGroup->checkedId();
 if(button_num == 0)
  FF = "-cg";
 else
  FF = "-sd";
}

double Dialog_MM::get_criteria() {
 QString str = LeCriteria->text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "収束条件が空欄です．");
  return -1.0;
 }

 double val = str.toDouble();
 if(val <= 1e-7f || 1e-4f <= val) {
  QMessageBox::critical(this, "エラー", "収束条件が設定範囲外です．");
  return -1.0;
 }

 return val;
}

int Dialog_MM::get_steps() {
 int val = -1;

 QString str = LeSteps->text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "ステップ数が空欄です．");
  return -1;
 }
 val = str.toDouble();

 return val;
}

