#include "dialog_mutate.h"
#include <array>
#include <QGroupBox>
#include <QPushButton>
#include <QVBoxLayout>

Dialog_Mutate::Dialog_Mutate(QWidget *parent)
 : QDialog(parent),
   SubstCode('A')
{
 //アミノ酸の名前を libbuilcule/libbuilcule_global.h に作成した
 //利用すること
 const int aa_cnt = 20;  //Pro 以外
 std::array<std::string, aa_cnt> name;
 name[0] = "Ala";
 name[1] = "Arg";
 name[2] = "Asn";
 name[3] = "Asp";
 name[4] = "Cys";
 name[5] = "Gln";
 name[6] = "Glu";
 name[7] = "Gly";
 name[8] = "His";
 name[9] = "Ile";
 name[10] = "Leu";
 name[11] = "Lys";
 name[12] = "Met";
 name[13] = "Phe";
 name[14] = "Ser";
 name[15] = "Thr";
 name[16] = "Trp";
 name[17] = "Tyr";
 name[18] = "Val";
 name[19] = "Pro";

 setModal(true);
 setWindowTitle("アミノ酸を選択");

 QWidget *central_widget = new QWidget(this);
 QVBoxLayout *central_layout = new QVBoxLayout(this);
 central_widget->setLayout(central_layout);

 std::array<QRadioButton *, aa_cnt> buttonArray;
 for(int i = 0; i < aa_cnt; ++i) {
  buttonArray[i] = new QRadioButton(name[i].data(), this);
  central_layout->addWidget(buttonArray[i]);
  ButtonGroupSubst.addButton(buttonArray[i], i);
 }
 buttonArray[0]->setChecked(true);
 connect(&ButtonGroupSubst, SIGNAL(buttonClicked(int)), this, SLOT(slot_subst_button_clicked()));

 //OK/Cancel ボタンを配置する
 QWidget *ok_widget = new QWidget(this);
 central_layout->addWidget(ok_widget);
 QHBoxLayout *ok_layout = new QHBoxLayout(ok_widget);

 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));
 ok_layout->addWidget(cancel_button);

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 connect(ok_button, SIGNAL(clicked()), this, SLOT(accept()));
 ok_layout->addWidget(ok_button);

 //ウィンドウサイズ
 setFixedSize(200, 750);
}

void Dialog_Mutate::slot_subst_button_clicked() {
 switch(ButtonGroupSubst.checkedId()) {
  case 0:
   SubstCode = 'A';
   break;
  case 1:
   SubstCode = 'R';
   break;
  case 2:
   SubstCode = 'N';
   break;
  case 3:
   SubstCode = 'D';
   break;
  case 4:
   SubstCode = 'C';
   break;
  case 5:
   SubstCode = 'Q';
   break;
  case 6:
   SubstCode = 'E';
   break;
  case 7:
   SubstCode = 'G';
   break;
  case 8:
   SubstCode = 'H';
   break;
  case 9:
   SubstCode = 'I';
   break;
  case 10:
   SubstCode = 'L';
   break;
  case 11:
   SubstCode = 'K';
   break;
  case 12:
   SubstCode = 'M';
   break;
  case 13:
   SubstCode = 'F';
   break;
  case 14:
   SubstCode = 'S';
   break;
  case 15:
   SubstCode = 'T';
   break;
  case 16:
   SubstCode = 'W';
   break;
  case 17:
   SubstCode = 'Y';
   break;
  case 18:
   SubstCode = 'V';
   break;
  case 19:
   SubstCode = 'P';
   break;
  default:
   break;
 }
}

