#include "dialog_subst.h"
#include <iostream>
#include <QPushButton>
#include <QScrollArea>
#include <QVBoxLayout>

Dialog_Subst::Dialog_Subst(
        QWidget *parent, const std::vector<std::string> *name)
 : QDialog(parent)
{
 QWidget *central_widget = new QWidget(this);
 QVBoxLayout *central_layout = new QVBoxLayout(central_widget);
 central_widget->setLayout(central_layout);
 central_widget->setMinimumWidth(250);
 central_widget->setMinimumHeight(400);

 //リスト
 SubstList = new QListWidget(this);
 SubstList->setSelectionMode(QAbstractItemView::SingleSelection);
 central_layout->addWidget(SubstList);

 int cnt = name->size();
 if(cnt) {
  for(int i = 0; i < cnt; ++i) {
   SubstList->addItem((*name)[i].data());
  }
  SubstList->item(0)->setSelected(true);
 }

 //OK/Cancel ボタンを配置する
 QWidget *ok_widget = new QWidget(this);
 central_layout->addWidget(ok_widget);
 QHBoxLayout *ok_layout = new QHBoxLayout(ok_widget);

 QPushButton *cancel_button = new QPushButton("Cancel", this);
 cancel_button->setFixedSize(80, 30);
 connect(cancel_button, SIGNAL(clicked()), this, SLOT(reject()));
 ok_layout->addWidget(cancel_button);

 QPushButton *ok_button = new QPushButton("OK", this);
 ok_button->setFixedSize(80, 30);
 connect(ok_button, SIGNAL(clicked()), this, SLOT(accept()));
 ok_layout->addWidget(ok_button);

 central_layout->setContentsMargins(0, 0, 0, 0);
}

int Dialog_Subst::get_subst_idx() {
 int cnt = SubstList->count();
 for(int i = 0; i !=cnt; ++i) {
  if(SubstList->item(i)->isSelected())
   return i;
 }
 std::cerr << __PRETTY_FUNCTION__ << std::endl;
 return -1;
}

