#ifndef ___SELECTOR_AA_H
#define ___SELECTOR_AA_H

#include <builcule/lb2/amino_acid.h>
#include <QBoxLayout>
#include <QTableWidget>
#include <QPushButton>

class Selector_AA : public QWidget {
 Q_OBJECT  //これが無いと，シグナルとスロットをコネクトできない

 private:
  bool Updating;
  std::map<std::array<int, 3>, int> SearchMap;
  std::vector<int> SelectedIdx;
  std::vector<AA_Memo> SelectedAAData;

  //主なウィジェット．ここに記すのは，大まかなデザインを示すため
  QVBoxLayout *LayoutCentral;
  QTableWidget *TableWidgetAA;
  QPushButton *ButtonClear;
  QPushButton *ButtonInvert;
  QPushButton *ButtonDetete;
  QPushButton *ButtonMutate;

  void select(const std::array<int, 3> &key);

 signals:  //一部はメインウィンドウにも送信する
  void selection_updated();
  void button_clear();
  void button_invert();
  void button_delete();
  void button_mutate();

 public slots:  //シグナルを送信する関数もスロット
  void emit_selection_updated() { selection_updated(); }
  void emit_button_clear() { button_clear(); }
  void emit_button_invert() { button_invert(); }
  void emit_button_delete() { button_delete(); }
  void emit_button_mutate() { button_mutate(); }

 private slots:
  void slot_selection_updated();
  void slot_selection_clear();
  void slot_selection_invert();
  void slot_selection_delete() { emit_button_delete(); }
  void slot_selection_mutate() { emit_button_mutate(); }

 public:
  Selector_AA(QWidget *parent = nullptr);

  int get_row_cnt() const { return TableWidgetAA->rowCount(); }
  void clear_contents()
        {TableWidgetAA->clearContents(); }  //ヘッダは残る
  void set_item(const std::vector<std::vector<AA_Memo>> *aa_data);
  void select(const std::vector<std::array<int, 3>> *vect);
  const std::vector<AA_Memo> *get_selected_aa_data();
};

#endif

