#include "selector_mol.h"
#include <QLabel>

Selector_Mol::Selector_Mol(QWidget *parent)
 : QWidget(parent),
   Updating(false),
   ListWidgetMol(nullptr)
{
 //大まかなレイアウトを作成する．サイズ Builcule_Main のコンストラクタ
 LayoutCentral = new QVBoxLayout(this);

 //ラベル
 QLabel *label_mol = new QLabel(tr("分子リスト"), this);
 LayoutCentral->addWidget(label_mol);

 //リスト
 ListWidgetMol = new QListWidget(this);
 ListWidgetMol->setSelectionMode(
        QAbstractItemView::ExtendedSelection);
 LayoutCentral->addWidget(ListWidgetMol);
 connect(ListWidgetMol, SIGNAL(itemSelectionChanged()),
        this, SLOT(slot_selection_updated()));

 //操作ボタン
 ButtonClear = new QPushButton(tr("選択を解除"), this);
 ButtonClear->setToolTip("分子の選択を解除します");
 LayoutCentral->addWidget(ButtonClear);
 connect(ButtonClear, SIGNAL(clicked()),
        this, SLOT(slot_selection_clear()));

 ButtonInvert = new QPushButton(tr("選択を反転"), this);
 ButtonInvert->setToolTip("分子の選択 / 非選択を反転します");
 LayoutCentral->addWidget(ButtonInvert);
 connect(ButtonInvert, SIGNAL(clicked()),
        this, SLOT(slot_selection_invert()));

 ButtonCopy = new QPushButton(tr("分子をコピー"), this);
 ButtonCopy->setToolTip("選択された分子をコピーします");
 LayoutCentral->addWidget(ButtonCopy);
 connect(ButtonCopy, SIGNAL(pressed()),
        this, SLOT(slot_selection_copy()));

 ButtonCut = new QPushButton(tr("分子をカット"), this);
 ButtonCut->setToolTip("選択された分子をカットします");
 LayoutCentral->addWidget(ButtonCut);
 connect(ButtonCut, SIGNAL(pressed()),
        this, SLOT(slot_selection_cut()));

 ButtonPaste = new QPushButton(tr("分子をペースト"), this);
 ButtonPaste->setToolTip("コピーされた分子をペーストします．別のユニットにペーストすることもできます");
 LayoutCentral->addWidget(ButtonPaste);
 connect(ButtonPaste, SIGNAL(pressed()),
        this, SLOT(slot_selection_paste()));

 //サイズポリシー
 LayoutCentral->setContentsMargins(0, 0, 0, 0);
}

void Selector_Mol::create_list() {
 //前回の選択をバックアップ
 int old_cnt = ListWidgetMol->count();
 SelectionBefore.assign(old_cnt, 0);
 for(int i = 0; i != old_cnt; ++i) {
  QListWidgetItem *item = ListWidgetMol->item(i);
  SelectionBefore[i] = item->isSelected();
 }

 //新規作成
 if(ListWidgetMol)
  delete ListWidgetMol;
 ListWidgetMol = new QListWidget(this);
 ListWidgetMol->setSelectionMode(
        QAbstractItemView::ExtendedSelection);
 LayoutCentral->insertWidget(1, ListWidgetMol);
 connect(ListWidgetMol, SIGNAL(itemSelectionChanged()),
        this, SLOT(slot_selection_updated()));

 Selection.assign(0, 0);
 slot_selection_updated();
}

void Selector_Mol::create_list(
        const std::vector<Molecule> *mol_vect) {
 create_list();

 int cnt = mol_vect->size();
 for(int i = 0; i < cnt; ++i) {
  QString str0 = QString::number(i);
  QString str1 = QString::number((*mol_vect)[i].get_atom_cnt());
  ListWidgetMol->addItem(str0 + " : " + str1);
 }

 Selection.assign(cnt, 0);
 slot_selection_updated();
}

void Selector_Mol::select(const std::vector<int> *mol_idx) {
 Updating = true;

 for(int idx : *mol_idx) {
  QListWidgetItem *item = ListWidgetMol->item(idx);
  item->setSelected(true);
 }

 Updating = false;
 slot_selection_updated();
}

void Selector_Mol::restore_old_selection() {
 Updating = true;

 int cnt = SelectionBefore.size();
 for(int i = 0; i != cnt; ++i) {
  if(SelectionBefore[i]) {
   QListWidgetItem *item = ListWidgetMol->item(i);
   item->setSelected(true);
  }
 }

 Updating = false;
 slot_selection_updated();
}

void Selector_Mol::slot_selection_clear() {
 Updating = true;

 int cnt = ListWidgetMol->count();
 for(int i = 0; i != cnt; ++i)
  ListWidgetMol->item(i)->setSelected(false);

 Updating = false;
 slot_selection_updated();
}

void Selector_Mol::slot_selection_invert() {
 Updating = true;

 QListWidgetItem *item;
 int cnt = ListWidgetMol->count();
 for(int i = 0; i < cnt; ++i) {
  item = ListWidgetMol->item(i);
  if(item->isSelected())
   item->setSelected(false);
  else
   item->setSelected(true);
 }

 Updating = false;
 slot_selection_updated();
}

void Selector_Mol::slot_selection_updated() {
 if(Updating)
  return;

 int cnt = ListWidgetMol->count();
 for(int i = 0; i != cnt; ++i) {
  QListWidgetItem *item = ListWidgetMol->item(i);
  Selection[i] = item->isSelected();
 }

 emit_selection_updated();
}

int Selector_Mol::first_selected_idx() {
 int cnt = ListWidgetMol->count();
 QListWidgetItem *item;
 for(int i = 0; i != cnt; ++i) {
  item = ListWidgetMol->item(i);
  if(item->isSelected())
   return i;
 }

 return -1;
}

const std::vector<int> *Selector_Mol::get_selected_idx() {
 SelectedIdx.clear();
 SelectedIdx.shrink_to_fit();

 int cnt = ListWidgetMol->count();
 for(int i = 0; i != cnt; ++i) {
  QListWidgetItem *item = ListWidgetMol->item(i);
  if(item->isSelected())
   SelectedIdx.push_back(i);
 }

 return &SelectedIdx;
}

