#ifndef ___SELECTOR_MOL_H
#define ___SELECTOR_MOL_H


//メインウィンドウ上のオブジェクトにするとコンストラクタが煩雑になる

#include <builcule/lb2/molecule.h>
#include <QBoxLayout>
#include <QListWidget>
#include <QPushButton>

class Selector_Mol : public QWidget {
 Q_OBJECT  //これが無いと，シグナルとスロットをコネクトできない

 private:
  bool Updating;
  std::vector<int> Selection;
  std::vector<int> SelectionBefore;  //分子の追加時に選択を保持する
  std::vector<int> SelectedIdx;

  //主なウィジェット．ここに記すのは，大まかなデザインを示すため
  QVBoxLayout *LayoutCentral;
  QListWidget *ListWidgetMol;
  QPushButton *ButtonClear;
  QPushButton *ButtonInvert;
  QPushButton *ButtonCopy;
  QPushButton *ButtonCut;
  QPushButton *ButtonPaste;

 signals:  //一部はメインウィンドウにも送信する
  void selection_updated();
  void button_clear();
  void button_invert();
  void button_copy();
  void button_cut();
  void button_paste();

 public slots:  //シグナルを送信する関数もスロット
  void emit_selection_updated() { selection_updated(); }
  void emit_button_clear() { button_clear(); }
  void emit_button_invert() { button_invert(); }
  void emit_button_copy() { button_copy(); }
  void emit_button_cut() { button_cut(); }
  void emit_button_paste() { button_paste(); }

 private slots:
  void slot_selection_updated();
  void slot_selection_clear();
  void slot_selection_invert();
  void slot_selection_copy() { emit_button_copy(); }
  void slot_selection_cut() { emit_button_cut(); }
  void slot_selection_paste() { emit_button_paste(); }

 public:
  Selector_Mol(QWidget *parent = nullptr);

  int cnt() const { return ListWidgetMol->count(); }
  void clear() { ListWidgetMol->clear(); }
  void create_list();
  void create_list(const std::vector<Molecule> *mol_vect);
  void select(const std::vector<int> *mol_num);

  int first_selected_idx();
  void restore_old_selection();  //分子の追加時に選択を保持する
  const std::vector<int> *get_selected_idx();
};

#endif

