#include "unit_bak.h"

void Unit_Bak::import_undo(
        int unit,
        const std::vector<std::shared_ptr<Atom>> *unit_atom,
        const Eigen::Vector3d *center,
        double radius,
        const Eigen::Vector3d *pos,
        Draw_Model model) {
 Unit_Seed seed;
 encopy(*unit_atom, seed.AtomSeedVect);
 seed.Center = *center;
 seed.Radius = radius;
 seed.Pos = *pos;
 seed.Model = model;
 UnitUndo[unit].push(seed);
}

void Unit_Bak::import_redo(
        int unit,
        const std::vector<std::shared_ptr<Atom>> *unit_atom,
        const Eigen::Vector3d *center,
        double radius,
        const Eigen::Vector3d *pos,
        Draw_Model model) {
 encopy(*unit_atom, UnitRedo[unit].AtomSeedVect);
 UnitRedo[unit].Center = *center;
 UnitRedo[unit].Radius = radius;
 UnitRedo[unit].Pos = *pos;
 UnitRedo[unit].Model = model;
}

const Unit_Return *Unit_Bak::pop_undo(int unit) {
 ReturnUnit.AtomVect.clear();
 ReturnUnit.AtomVect.shrink_to_fit();

 if(!UnitUndo[unit].empty()) {
  const auto &atom_seed_vect = UnitUndo[unit].top().AtomSeedVect;
  //decopy(ReturnUnit.AtomVect, atom_seed_vect);
  decopy(atom_seed_vect, ReturnUnit.AtomVect);
  ReturnUnit.Center = UnitUndo[unit].top().Center;
  ReturnUnit.Radius = UnitUndo[unit].top().Radius;
  ReturnUnit.Pos = UnitUndo[unit].top().Pos;
  ReturnUnit.Model = UnitUndo[unit].top().Model;
  UnitUndo[unit].pop();
 }

 return &ReturnUnit;
}

const Unit_Return *Unit_Bak::get_redo(int unit) {
 ReturnUnit.AtomVect.clear();
 ReturnUnit.AtomVect.shrink_to_fit();

 if(!UnitRedo[unit].AtomSeedVect.empty()) {
  const auto &atom_seed_vect = UnitRedo[unit].AtomSeedVect;
  //decopy(ReturnUnit.AtomVect, atom_seed_vect);
  decopy(atom_seed_vect, ReturnUnit.AtomVect);
  ReturnUnit.Center = UnitRedo[unit].Center;
  ReturnUnit.Radius = UnitRedo[unit].Radius;
  ReturnUnit.Pos = UnitRedo[unit].Pos;
  ReturnUnit.Model = UnitRedo[unit].Model;

  UnitRedo[unit].AtomSeedVect.clear();
  UnitRedo[unit].AtomSeedVect.shrink_to_fit();
 }

 return &ReturnUnit;
}

