#ifndef ___UNIT_BAK_H
#define ___UNIT_BAK_H

#include "builcule_global.h" //Draw_Model が定義されている
#include <builcule/lb2/copy_base.h>
#include <stack>

//Unit のバックアップ返却用．Main_Window に返却するので外部に作成
struct Unit_Return {
  std::vector<std::shared_ptr<Atom>> AtomVect;
  Eigen::Vector3d Center;
  double Radius;
  Eigen::Vector3d Pos;
  Draw_Model Model;
};

class Unit_Bak : private Copy_Base {

//Unit のバックアップ用
struct Unit_Seed {
  std::vector<Atom_Seed> AtomSeedVect;
  Eigen::Vector3d Center;
  double Radius;
  Eigen::Vector3d Pos;
  Draw_Model Model;
};

 private:
  std::array<std::stack<Unit_Seed>, 3> UnitUndo;
  std::array<Unit_Seed, 3> UnitRedo;

  //ユニットの返却用のインスタンス
  Unit_Return ReturnUnit;

 public:
  //バックアップとリストア用
  void import_undo(
        int unit,
        const std::vector<std::shared_ptr<Atom>> *unit_atom,
        const Eigen::Vector3d *center,
        double radius,
        const Eigen::Vector3d *pos,
        Draw_Model model);

  void import_redo(
        int unit,
        const std::vector<std::shared_ptr<Atom>> *unit_atom,
        const Eigen::Vector3d *center,
        double radius,
        const Eigen::Vector3d *pos,
        Draw_Model model);

  const Unit_Return *pop_undo(int unit);
  const Unit_Return *get_redo(int unit);
};

#endif
