#include "widget_draw_base.h"

Widget_Draw_Base::Widget_Draw_Base(QWidget *parent)
 : QOpenGLWidget(parent),
   QSurface(gluNewQuadric()),
   EyePos(Eigen::Vector3d::Zero(3)),
   DrawCenter(Eigen::Vector3d::Zero(3)),
   DrawRadius(0.0),
   ViewAngle(2.0 * asin(0.1) * (180.0 / M_PI)),
   Front(0.0),
   Back(0.0),
   Slices(0),
   Stacks(0),
   ZAxis(0.0, 0.0, 1.0),
   BallRadiusH(0.35f),
   BallRadiusX(0.5f),
   StickRadius(0.15f),
   MouseRotateRatio(0.0),
   MouseMoveRatio(0.0),
   PressedButton(Qt::NoButton),
   MouseX(0),
   MouseY(0)
{
 setMinimumWidth(600);
 setMinimumHeight(600);
 setSizePolicy(QSizePolicy(
        QSizePolicy::Expanding, QSizePolicy::Expanding));

 PopupWidget = new QWidget(this);
 PopupWidget->setWindowFlags(Qt::ToolTip);
 QVBoxLayout *popup_layout = new QVBoxLayout(PopupWidget);
 PopupLabel = new QLabel(PopupWidget);
 PopupLabel->setStyleSheet("background-color:white;");
 popup_layout->addWidget(PopupLabel);
 popup_layout->setContentsMargins(0, 0, 0, 0);
 PopupWidget->setLayout(popup_layout);

 AnnotMap[AA_Atom::C] = "C";
 AnnotMap[AA_Atom::CA] = "CA";
 AnnotMap[AA_Atom::CB] = "CB";
 AnnotMap[AA_Atom::CD] = "CD";
 AnnotMap[AA_Atom::CD1] = "CD1";
 AnnotMap[AA_Atom::CD2] = "CD2";
 AnnotMap[AA_Atom::CE] = "CE";
 AnnotMap[AA_Atom::CE1] = "CE1";
 AnnotMap[AA_Atom::CE2] = "CE2";
 AnnotMap[AA_Atom::CG] = "CG";
 AnnotMap[AA_Atom::CG1] = "CG1";
 AnnotMap[AA_Atom::CG2] = "CG2";
 AnnotMap[AA_Atom::CH2] = "CH2";
 AnnotMap[AA_Atom::CZ] = "CZ";
 AnnotMap[AA_Atom::CZ2] = "CZ2";
 AnnotMap[AA_Atom::CZ3] = "CZ3";
 AnnotMap[AA_Atom::N] = "N";
 AnnotMap[AA_Atom::ND1] = "ND1";
 AnnotMap[AA_Atom::ND2] = "ND2";
 AnnotMap[AA_Atom::NE] = "NE";
 AnnotMap[AA_Atom::NE1] = "NE1";
 AnnotMap[AA_Atom::NE2] = "NE2";
 AnnotMap[AA_Atom::NH1] = "NH1";
 AnnotMap[AA_Atom::NH2] = "NH2";
 AnnotMap[AA_Atom::NZ] = "NZ";
 AnnotMap[AA_Atom::O] = "O";
 AnnotMap[AA_Atom::OD] = "OD";
 AnnotMap[AA_Atom::OD1] = "OD1";
 AnnotMap[AA_Atom::OD2] = "OD2";
 AnnotMap[AA_Atom::OE1] = "OE1";
 AnnotMap[AA_Atom::OE2] = "OE2";
 AnnotMap[AA_Atom::OG] = "OG";
 AnnotMap[AA_Atom::OG1] = "OG1";
 AnnotMap[AA_Atom::OH] = "OH";
 AnnotMap[AA_Atom::SD] = "SD";
 AnnotMap[AA_Atom::SG] = "SG";
 AnnotMap[AA_Atom::OXT] = "OXT";
}

void Widget_Draw_Base::initializeGL() {
 glClearColor(1.0, 1.0, 1.0, 1.0); //背景を白色に設定
 glEnable(GL_DEPTH_TEST);
 glEnable(GL_ALPHA_TEST);
}

void Widget_Draw_Base::resizeGL(int width, int height) {
 GLsizei length = (width > height) ? height : width;
 resize(length, length);  //描画領域を正方形に保つ
}

void Widget_Draw_Base::set_projection() {
 //射影変換
 glMatrixMode(GL_PROJECTION);
 glLoadIdentity();
 //field of view, aspect ratio, depth range
 gluPerspective(ViewAngle, 1.0, Front, Back);
}

void Widget_Draw_Base::set_lookat() {
 //モデルビュー変換
 glMatrixMode(GL_MODELVIEW);
 glLoadIdentity();
 //view point, focus point, up vector
 gluLookAt(EyePos[0], EyePos[1], EyePos[2],
        DrawCenter[0], DrawCenter[1], DrawCenter[2],
        0.0, 1.0, 0.0);
}

