#ifndef ___WIDGET_DRAW_BASE_H
#define ___WIDGET_DRAW_BASE_H

#include "builcule_global.h"
#include <builcule/lb2/global.h>
#include <Eigen/Dense>
#include <GL/glu.h>
#include <QLabel>
#include <QMessageBox>
#include <QMouseEvent>
#include <QOpenGLWidget>
#include <QVBoxLayout>
#include <QWheelEvent>

/*
*Unit と Builcule_Unit のどちらかを使うので，ここでは設定しない
必要に応じ，継承クラスで *Builcule_Unit または *Unit を設定する
*AtomVect は，編集によりアドレスが変わる場合があるので，ここでは設定しない
*/

class Widget_Draw_Base : public QOpenGLWidget {
 protected:
  GLUquadricObj *QSurface;
  Eigen::Vector3d EyePos;
  Eigen::Vector3d DrawCenter;
  double DrawRadius;
  double ViewAngle;
  GLdouble Front;  //視点からの最小距離
  GLdouble Back;  //視点からの最大距離
  GLint Slices;  //オブジェクトの分割数（経度のイメージ）
  GLint Stacks;  //オブジェクトの分割数（緯度のイメージ）
  const Eigen::Vector3d ZAxis;

  const float BallRadiusH;
  const float BallRadiusX;
  const float StickRadius;

  QWidget *PopupWidget;
  QLabel *PopupLabel;

  std::map<AA_Atom, QString> AnnotMap;

  double MouseRotateRatio;
  double MouseMoveRatio;
  Qt::MouseButton PressedButton;
  int MouseX;
  int MouseY;

  void initializeGL() override;
  void resizeGL(int width, int height) override;
  void paintGL() override {};
  void set_projection();
  void set_lookat();

 public:
  Widget_Draw_Base(QWidget *parent = nullptr);

 protected:
//描画用構造体
  struct Sphere {
   const Eigen::Vector3d *Pos;
   float Radius;
   float Color[4];
   int SerialNum;
   int Elmt;
   QString Symbol;
   int MolIdx;
   int PeptIdx;
   int SeqIdx;
   std::string Code;
   QString Annot;
   Sphere()
    :
    Pos(nullptr),
    Radius(0.1f),
    SerialNum(-1),
    Elmt(-1),
    MolIdx(-1),
    PeptIdx(-1),
    SeqIdx(-1)
   {
    for(int i = 0; i < 4; ++i)
     Color[i] = ColorCPK[0][i];
   }
  };

  struct Cylinder {
   const Eigen::Vector3d *Pos0;
   const Eigen::Vector3d *Pos1;
   float Radius;
   float Color[4];
   Cylinder()
    : Pos0(nullptr), Pos1(nullptr), Radius(0.2f)
   {
    for(int i = 0; i < 4; ++i)
     Color[i] = ColorCPK[0][i];
   }
  };

  struct Wire {
   const Eigen::Vector3d *Pos0;
   const Eigen::Vector3d *Pos1;
   float Color[4];
   Wire()
    : Pos0(nullptr), Pos1(nullptr)
   {
    for(int i = 0; i < 4; ++i)
     Color[i] = ColorDiff[6][i];
   }
  };

  //色データ 1
  inline static const
        std::array<std::array<float, 4>, 7> ColorDiff {
   1.000000f, 0.000000f, 0.000000f, 1.0f,  //赤色
   0.000000f, 0.000000f, 1.000000f, 1.0f,  //青色
   1.000000f, 1.000000f, 0.000000f, 1.0f,  //黄色
   0.000000f, 1.000000f, 0.000000f, 1.0f,  //緑色
   0.000000f, 1.000000f, 1.000000f, 1.0f,  //シアン
   1.000000f, 0.000000f, 1.000000f, 1.0f,  //マゼンダ
   0.000000f, 0.000000f, 0.000000f, 1.0f   //黒色
  };

  //色データ 2．結合色は，水素と炭素の中間色
  inline static const
          std::array<std::array<float, 4>, 121> ColorCPK {
   0.800000f, 0.800000f, 0.800000f, 1.0f ,  //0 : 結合色
   0.920000f, 1.000000f, 1.000000f, 1.0f ,  //1
   0.850980f, 1.000000f, 1.000000f, 1.0f ,  //2
   0.800000f, 0.501961f, 1.000000f, 1.0f ,  //3
   0.760784f, 1.000000f, 0.000000f, 1.0f ,  //4
   1.000000f, 0.709804f, 0.709804f, 1.0f ,  //5
   0.564706f, 0.564706f, 0.564706f, 1.0f ,  //6
   0.188235f, 0.313725f, 0.972549f, 1.0f ,  //7
   1.000000f, 0.050980f, 0.050980f, 1.0f ,  //8
   0.564706f, 0.878431f, 0.313725f, 1.0f ,  //9
   0.701961f, 0.890196f, 0.960784f, 1.0f ,  //10
   0.670588f, 0.360784f, 0.949020f, 1.0f ,  //11
   0.054118f, 1.000000f, 0.000000f, 1.0f ,  //12
   0.749020f, 0.650980f, 0.650980f, 1.0f ,  //13
   0.941176f, 0.784314f, 0.627451f, 1.0f ,  //14
   1.000000f, 0.501961f, 0.000000f, 1.0f ,  //15
   1.000000f, 1.000000f, 0.188235f, 1.0f ,  //16
   0.012157f, 0.941176f, 0.121569f, 1.0f ,  //17
   0.501960f, 0.819601f, 0.890196f, 1.0f ,  //18
   0.560784f, 0.250980f, 0.831373f, 1.0f ,  //19
   0.239216f, 1.000000f, 0.000000f, 1.0f ,  //20
   0.901961f, 0.901961f, 0.901961f, 1.0f ,  //21
   0.749020f, 0.760784f, 0.780392f, 1.0f ,  //22
   0.650980f, 0.650980f, 0.670588f, 1.0f ,  //23
   0.541176f, 0.600000f, 0.780392f, 1.0f ,  //24
   0.611765f, 0.478431f, 0.780392f, 1.0f ,  //25
   0.878431f, 0.400000f, 0.200000f, 1.0f ,  //26
   0.941176f, 0.564706f, 0.627451f, 1.0f ,  //27
   0.313725f, 0.815686f, 0.313725f, 1.0f ,  //28
   0.784314f, 0.501961f, 0.200000f, 1.0f ,  //29
   0.490196f, 0.501961f, 0.690196f, 1.0f ,  //30
   0.760784f, 0.560784f, 0.560784f, 1.0f ,  //31
   0.400000f, 0.560784f, 0.560784f, 1.0f ,  //32
   0.741176f, 0.501961f, 0.890196f, 1.0f ,  //33
   1.000000f, 0.631373f, 0.000000f, 1.0f ,  //34
   0.650980f, 0.160784f, 0.160784f, 1.0f ,  //35
   0.360784f, 0.721569f, 0.819608f, 1.0f ,  //36
   0.439216f, 0.180392f, 0.690196f, 1.0f ,  //37
   0.000000f, 1.000000f, 0.000000f, 1.0f ,  //38
   0.580392f, 1.000000f, 1.000000f, 1.0f ,  //39
   0.580392f, 0.878431f, 0.878431f, 1.0f ,  //40
   0.450980f, 0.760784f, 0.788235f, 1.0f ,  //41
   0.329412f, 0.709804f, 0.709804f, 1.0f ,  //42
   0.231372f, 0.619608f, 0.619608f, 1.0f ,  //43
   0.141176f, 0.560784f, 0.560784f, 1.0f ,  //44
   0.039220f, 0.490196f, 0.549020f, 1.0f ,  //45
   0.000000f, 0.411765f, 0.521569f, 1.0f ,  //46
   0.752941f, 0.752941f, 0.752941f, 1.0f ,  //47
   1.000000f, 0.850980f, 0.560784f, 1.0f ,  //48
   0.650980f, 0.458824f, 0.450980f, 1.0f ,  //49
   0.400000f, 0.501961f, 0.501961f, 1.0f ,  //50
   0.619608f, 0.388235f, 0.709804f, 1.0f ,  //51
   0.831373f, 0.478431f, 0.000000f, 1.0f ,  //52
   0.580392f, 0.000000f, 0.580392f, 1.0f ,  //53
   0.258824f, 0.619608f, 0.690196f, 1.0f ,  //54
   0.341176f, 0.090196f, 0.560784f, 1.0f ,  //55
   0.000000f, 0.788235f, 0.000000f, 1.0f ,  //56
   0.439216f, 0.831373f, 1.000000f, 1.0f ,  //57
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //58 : 色未指定
   0.850980f, 1.000000f, 0.780392f, 1.0f ,  //59
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //60 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //61 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //62 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //63 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //64 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //65 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //66 : 色未指定
   0.000000f, 1.000000f, 0.611765f, 1.0f ,  //67
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //68 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //69 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //70 : 色未指定
   0.000000f, 0.670588f, 0.121569f, 1.0f ,  //71
   0.301961f, 0.721569f, 1.000000f, 1.0f ,  //72
   0.301961f, 0.650980f, 1.000000f, 1.0f ,  //73
   0.129412f, 0.580392f, 0.839216f, 1.0f ,  //74
   0.149020f, 0.490196f, 0.670588f, 1.0f ,  //75
   0.149020f, 0.400000f, 0.588235f, 1.0f ,  //76
   0.090196f, 0.329412f, 0.529412f, 1.0f ,  //77
   0.815686f, 0.815686f, 0.878431f, 1.0f ,  //78
   1.000000f, 0.819608f, 0.137255f, 1.0f ,  //79
   0.721569f, 0.721569f, 0.815686f, 1.0f ,  //80
   0.650980f, 0.329412f, 0.301961f, 1.0f ,  //81
   0.341176f, 0.349020f, 0.380392f, 1.0f ,  //82
   0.619608f, 0.309804f, 0.709804f, 1.0f ,  //83
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //84 : 色未指定
   0.458824f, 0.309804f, 0.270588f, 1.0f ,  //85
   0.258824f, 0.309804f, 0.588235f, 1.0f ,  //86
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //87 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //88 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //89 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //90 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //91 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //92 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //93 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //94 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //95 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //96 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //97 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //98 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //99 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //100 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //101 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //102 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //103 : 色未指定
   0.800000f, 0.000000f, 0.349020f, 1.0f ,  //104
   0.819608f, 0.000000f, 0.309804f, 1.0f ,  //105
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //106 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //107 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //108 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //109 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //110 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //111 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //112 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //113 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //114 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //115 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //116 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //117 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //118 : 色未指定
   1.000000f, 1.000000f, 1.000000f, 1.0f ,  //119 : 色未指定
   0.980392f, 0.086275f, 0.568627f, 1.0f    //120 : pick 色
  };
};

#endif

