#include "widget_show_align.h"
#include <QGroupBox>
#include <QLabel>
#include <QRadioButton>

Widget_Show_Align::Widget_Show_Align(QWidget *parent, int &num)
 : QWidget(parent),
   AlignNum(num),
   Alignment(nullptr),
   Score(nullptr),
   IniTer(nullptr)
{
 //アミノ酸の色
 AAColor['D'] = Qt::red;  AAColor['E'] = Qt::red;

 AAColor['H'] = Qt::blue;  AAColor['K'] = Qt::blue;
 AAColor['R'] = Qt::blue;

 AAColor['C'] = Qt::yellow;
 AAColor['c'] = Qt::yellow;

 AAColor['G'] = Qt::green;  AAColor['N'] = Qt::green;
 AAColor['Q'] = Qt::green;  AAColor['S'] = Qt::green;
 AAColor['T'] = Qt::green;  AAColor['Y'] = Qt::green;

 AAColor['A'] = Qt::white;  AAColor['F'] = Qt::white;
 AAColor['I'] = Qt::white;  AAColor['L'] = Qt::white;
 AAColor['M'] = Qt::white;  AAColor['P'] = Qt::white;
 AAColor['V'] = Qt::white;  AAColor['W'] = Qt::white;
 AAColor['-'] = Qt::white;

 QWidget *widget_central = new QWidget(this);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);
 ScrollArea = new QScrollArea(widget_central);

 QWidget *widget_draw = new QWidget(ScrollArea);
 LayoutDraw = new QVBoxLayout(widget_draw);

 layout_central->addWidget(ScrollArea);
 ScrollArea->setWidget(widget_draw);
 ScrollArea->setWidgetResizable(true);
}

void Widget_Show_Align::show_align() {
 int cnt = Alignment->size();

 //選択ボタン
 create_button(cnt);

 //アラインメントを 1 個ずつ描画
 for(int i = 0; i != cnt; ++i) {
  //ラベル
  double score = (*Score)[i];
  int ini0 = (*IniTer)[i][0];
  int ter0 = (*IniTer)[i][1];
  int ini1 = (*IniTer)[i][2];
  int ter1 = (*IniTer)[i][3];
  draw_label(i, score, ini0, ter0, ini1, ter1);

  //配列
  draw_alignment(&(*Alignment)[i]);
 }
}

void Widget_Show_Align::create_button(int num) {
 //ボタンを配置するウィジェット
 QGroupBox *gbox_button
        = new QGroupBox("アラインメントの選択", this);
 QWidget *widget_button = new QWidget(gbox_button);
 gbox_button->setSizePolicy(
    QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
 //ボタングループ
 BGroupAlign = new QButtonGroup(widget_button);
 connect(BGroupAlign, SIGNAL(buttonClicked(int)),
        this, SLOT(slot_selection_updated()));
 LayoutDraw->addWidget(gbox_button);

 //個々のボタン
 QHBoxLayout *layout_button = new QHBoxLayout(gbox_button);
 for(int i = 0; i != num; ++i) {
  QRadioButton *button = new QRadioButton(gbox_button);
  BGroupAlign->addButton(button, i);
  button->setText(QString::number(i));
  layout_button->addWidget(button);
 }

 BGroupAlign->button(0)->setChecked(true);
}

void Widget_Show_Align::draw_label(
        int idx, double score,
        int ini0, int ter0, int ini1, int ter1) {
 QLabel *label = new QLabel(this);
 label->setSizePolicy(
    QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
 QString text = "アラインメント " + QString::number(idx) + ",  ";
 text += "スコア：" + QString::number(score) + ",  ";
 text += "配列 0：" + QString::number(ini0) + "-" + QString::number(ter0) + ",  ";
 text += "配列 1：" + QString::number(ini1) + "-" + QString::number(ter1);
 label->setText(text);
 LayoutDraw->addWidget(label);
}

void Widget_Show_Align::draw_alignment(
        const std::array<std::vector<char>, 3> *align) {
//その都度ラベルを作成し，QGridLayout を埋めつくす
//ラベルの使い回しはできない

 //配列を描画するウィジェットの作成
 QWidget *widget_seq = new QWidget(this);
 widget_seq->setSizePolicy(
    QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
 QGridLayout *layout_seq = new QGridLayout(widget_seq);
 layout_seq->setSpacing(0);

 QPalette pltt;
 QColor color;

 //目盛りの作成
 int cnt = (*align)[0].size();
 std::vector<char> scale(cnt, '-');
 //25 文字ごとに '+' を表示
 int pos = 0;
 while(pos < cnt) {
  scale[pos] = '+';
  pos += 25;
 }

 //QGridLayout 上での位置の指定用
 int column = 0;
 int pos0 = 0;
 int pos1 = 1;
 int pos2 = 2;
 int pos3 = 3;
 int pos4 = 4;

 //QGridLayout への貼り付け
 for(int i = 0; i != cnt; ++i) {
  //改行．100 残基ごとに設定した
  column = i % 100;
  if(!column && i) {
   pos0 += 5;
   pos1 += 5;
   pos2 += 5;
   pos3 += 5;
   pos4 += 5;
  }

  //目盛り
  QLabel *label0 = new QLabel(" ", widget_seq);
  if(scale[i] == '+')
   label0->setText("+");
  layout_seq->addWidget(label0, pos0, column);

  //配列 0
  QLabel *label1 = new QLabel(widget_seq);
  pltt = label1->palette();
  color = AAColor[(*align)[0][i]];
  pltt.setColor(QPalette::Window, color);  //背景色
  if(color == Qt::blue || color == Qt::red)
   pltt.setColor(QPalette::WindowText, Qt::white);  //文字色
  label1->setAutoFillBackground(true);
  label1->setPalette(pltt);
  label1->setText(QString((*align)[0][i]));
  layout_seq->addWidget(label1, pos1, column);

  //マッチング
  QLabel *label2 = new QLabel( " ", widget_seq);
  if((*align)[1][i] == '*')
   label2->setText("*");
  layout_seq->addWidget(label2, pos2, column);

  //配列 1
  QLabel *label3 = new QLabel(widget_seq);
  pltt = label3->palette();
  color = AAColor[(*align)[2][i]];
  pltt.setColor(QPalette::Window, color);  //背景色
  if(color == Qt::blue || color == Qt::red)
   pltt.setColor(QPalette::WindowText, Qt::white);  //文字色
  label3->setAutoFillBackground(true);
  label3->setPalette(pltt);
  label3->setText(QString((*align)[2][i]));
  layout_seq->addWidget(label3, pos3, column);
 }

 //空行
 QLabel *label4 = new QLabel(" ", widget_seq);
 label4->setText(" ");
 layout_seq->addWidget(label4, pos4, 0);
 LayoutDraw->addWidget(widget_seq);
}

