#ifndef ___WIDGET_SHOW_ALIGN_H
#define ___WIDGET_SHOW_ALIGN_H

#include <QButtonGroup>
#include <QMainWindow>
#include <QHBoxLayout>
#include <QScrollArea>

class Widget_Show_Align : public QWidget {
 Q_OBJECT

 private:
  //データ
  int &AlignNum;
  const std::vector<std::array<std::vector<char>, 3>> *Alignment;
  const std::vector<double> *Score;
  const std::vector<std::array<int, 4>> *IniTer;

  std::map<char, QColor> AAColor;

  //GUI オブジェクト
  QVBoxLayout *LayoutDraw;
  QScrollArea *ScrollArea;
  QButtonGroup *BGroupAlign;

  void create_button(int num);
  void draw_label(
    int idx, double score, int ini0, int ter0, int ini1, int ter1);
  void draw_alignment(
        const std::array<std::vector<char>, 3> *align);

 private slots:
  void slot_selection_updated()
    { AlignNum = BGroupAlign->checkedId(); }

 public:
  Widget_Show_Align(QWidget *parent, int &num);

  void set_scroll_area_size(int w, int h)
        { ScrollArea->setMinimumSize(w, h); }

  void set_alignment(
    const std::vector<std::array<std::vector<char>, 3>> *align)
        { Alignment = align; }
  void set_score(const std::vector<double> *score)
        { Score = score; }
  void set_ini_ter(const std::vector<std::array<int, 4>> *ini_ter)
        { IniTer = ini_ter; }

  void show_align();
};

#endif
