#include "widget_sup.h"

Widget_Sup::Widget_Sup(QWidget *parent, Unit *unit0, Unit *unit1)
 : Widget_Draw_Base(parent),
   UnitPtr{unit0, unit1}
{}

void Widget_Sup::set_wire_color(int idx) {
 for(Wire &wire : WireVect[idx]) {
  for(int i = 0; i != 4; ++i)
   wire.Color[i] = ColorDiff[idx][i];
 }
}

void Widget_Sup::push_wire() {
 Wire wire;

 for(int i = 0; i != 2; ++i) {
  WireVect[i].clear();
  WireVect[i].shrink_to_fit();

  const auto *atom_vect = UnitPtr[i]->get_atom_vect();
  for(const auto &atom0 : *atom_vect) {
   wire.Pos0 = atom0->get_xyz();
   const auto *bond = atom0->get_bond_up();
   for(const auto &atom1 : *bond) {
    wire.Pos1 = atom1->get_xyz();
    WireVect[i].push_back(wire);
   }
  }
  set_wire_color(i);
 }
}

void Widget_Sup::set_view_prm(
        const Eigen::Vector3d *center, double radius) {
 DrawCenter = *center;
 DrawRadius = radius + 2.5;

 EyePos[0] = DrawCenter[0];
 EyePos[1] = DrawCenter[1];
 EyePos[2] = DrawCenter[2] + DrawRadius * 10.0;

 Front = DrawRadius * 9.0;
 Back = DrawRadius * 11.0;
}

void Widget_Sup::paintGL() {
 glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
 set_projection();
 set_lookat();
 draw_wire();

 emit_drawed();
}

void Widget_Sup::draw_wire() {
 glBegin(GL_LINES);
 for(int i = 0; i != 2; ++i) {
  for(const Wire &wire : WireVect[i]) {
   glColor3f(wire.Color[0], wire.Color[1], wire.Color[2]);
   glVertex3f((*wire.Pos0)[0], (*wire.Pos0)[1], (*wire.Pos0)[2]);
   glVertex3f((*wire.Pos1)[0], (*wire.Pos1)[1], (*wire.Pos1)[2]);
  }
 }
 glEnd();
}

void Widget_Sup::mousePressEvent(QMouseEvent *event) {
 if(WireVect[0].empty())
  return;
 PressedButton = event->button();
 if(PressedButton != Qt::LeftButton)
  return;

 MouseRotateRatio = 180.0 / (double)width();
 MouseMoveRatio = 2.0 * DrawRadius / (double)width();
 MouseX = event->x();
 MouseY = event->y();
}

void Widget_Sup::mouseMoveEvent(QMouseEvent *event) {
 if(WireVect[0].empty())
  return;
 if(PressedButton != Qt::LeftButton)
  return;

 //MouseX，MouseY と event->x(), event->y() との差が移動度
 rotate_dual_unit(event->x(), event->y());
 repaint();

 //MouseX，MouseY を再設定
 MouseX = event->x();
 MouseY = event->y();
}

void Widget_Sup::rotate_dual_unit(int x0, int y0) {
 double dx = (double)(x0 - MouseX) * MouseRotateRatio;
 double dy = (double)(y0 - MouseY) * MouseRotateRatio;
 UnitPtr[0]->rotate_unit(dx, dy);
 UnitPtr[1]->rotate_unit(dx, dy);
}

void Widget_Sup::mouseReleaseEvent(QMouseEvent *event) {
 if(WireVect[0].empty())
  return;
 if(PressedButton != Qt::LeftButton)
  return;

 MouseX = event->x();
 MouseY = event->y();
 PressedButton = Qt::NoButton;
}


