#ifndef ___WIDGET_SUP_H
#define ___WIDGET_SUP_H

#include "widget_draw_base.h"
#include <builcule/lb2/unit.h>
#include <QWidget>

class Widget_Sup : public Widget_Draw_Base {
 Q_OBJECT
 private:
  //データ
  std::array<Unit*, 2> UnitPtr;  //回転操作があるので const ではない
  std::array<std::vector<Wire>, 2> WireVect;
  //描画
  void set_wire_color(int idx);
  void paintGL();
  void draw_wire();

 signals:
  void sig_drawed();  //Builcule_Draw を再描画するためのシグナル

 private slots:
  void emit_drawed() { sig_drawed(); }

 public:
  //構築
  Widget_Sup(QWidget *parent, Unit *unit0, Unit *unit1);

  //描画
  void push_wire();
  void set_view_prm(const Eigen::Vector3d *center, double radius);
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);
  void mouseReleaseEvent(QMouseEvent *event);
  void rotate_dual_unit(int x0, int y0);
};

#endif

