#include "window_align_3d.h"
#include <QGroupBox>
#include <QMessageBox>
#include <QValidator>

Window_Align_3D::Window_Align_3D(
        QWidget *parent,
        Builcule_Unit *unit0,
        Builcule_Unit *unit1,
        Config_File *config,
        Window_Sup *sup)
 : Window_Align_Base(parent, unit1, config, sup),
   Unit0(unit0),
   Mol0(0),
   Pept0(0),
   Ratio3D(0.0),
   Thres(0.1)
{
 //重ね合わせメニューを追加
 QAction *action_superimpose
        = new QAction("重ね合わせ", MenuBar);
 connect(action_superimpose, SIGNAL(triggered()),
        this, SLOT(slot_superimpose()));
 MenuCalc->addAction(action_superimpose);

 LabelC0.setText("ユニット 0");
 create_pept_combo(0, Unit0);
 //create_pept_combo(1, Unit1);  //これは基底クラスで作成済み

 //ウィンドウの設定
 QGroupBox *gbox_str0 = new QGroupBox("ウィンドウの設定",this);
 QGridLayout *layout_str0 = new QGridLayout(gbox_str0);

 QLabel *lb_win = new QLabel(this);
 lb_win->setText("ウィンドウ(1〜10)");

 layout_str0->addWidget(lb_win, 1, 0);
 layout_str0->addWidget(&LeWin, 1, 1);
 LayoutCentral->addWidget(gbox_str0);

 LeWin.insert(QString::number(Window));

 QValidator *val_win
        = new QIntValidator(1, 10, this);
 LeWin.setValidator(val_win);

 //構造アラインメントの設定
 QGroupBox *gbox_str1 = new QGroupBox("構造アラインメントの設定",this);
 QGridLayout *layout_str1 = new QGridLayout(gbox_str1);

 QLabel *lb_ratio = new QLabel(this);
 lb_ratio->setText("割合(%)");

 QLabel *lb_thres = new QLabel(this);
 lb_thres->setText("閾値");

 layout_str1->addWidget(lb_ratio, 2, 0);
 layout_str1->addWidget(&Le3DRatio, 2, 1);
 layout_str1->addWidget(lb_thres, 3, 0);
 layout_str1->addWidget(&LeThres, 3, 1);
 LayoutCentral->addWidget(gbox_str1);

 Le3DRatio.insert(QString::number(Ratio3D));
 LeThres.insert(QString::number(Thres));

 QValidator *val_ratio
        = new QDoubleValidator(0.0, 100.0, 1, this);
 Le3DRatio.setValidator(val_ratio);

 QValidator *val_thres
        = new QDoubleValidator(0.0, 1.0, 2, this);
 LeThres.setValidator(val_thres);
}

bool Window_Align_3D::capture_prm() {
 if(!capture_prm_base())
  return false;

 PeptIdx0 = PeptCombo[0].currentIndex();
 Mol0 = PeptNum[0][PeptIdx0][0];
 Pept0 = PeptNum[0][PeptIdx0][1];

 QString str = LeWin.text();
 Window = str.toInt();
 if(Window <= 0 || 10 < Window) {  //空欄だと 0 になる
  QMessageBox::critical(this, "エラー", "ウィンドウが異常値です．");
  return false;
 }

 str = Le3DRatio.text();
 if(str.isEmpty())
  Ratio3D = 0.0;
 Ratio3D = str.toDouble();
 if(Ratio3D < 0.00 || 100.0 < Ratio3D) {
  QMessageBox::critical(this, "エラー",
        "割合は 0.0 以上かつ 100.0 以下に設定してください．");
  return false;
 }

 str = LeThres.text();
 Thres = str.toDouble();
 if(Thres < 0.00 || 1.00 < Thres) {
  QMessageBox::critical(this, "エラー",
        "閾値は 0.00 以上かつ 1.00 以下に設定してください．");
  return false;
 }

 return true;
}

void Window_Align_3D::set_data() {
 set_data_base();

 Align.set_seq_xyz(0, Unit0->get_pept(Mol0, Pept0));
 Align.set_window(Window);
 Align.set_ratio_3d(Ratio3D);
 Align.set_thres(Thres);
}

void Window_Align_3D::slot_alignment() {
 if(!capture_prm()) return;

 set_data();
 Align.trace_for_sup();
 trace_back();
}

void Window_Align_3D::slot_superimpose() {
 if(AlignNum < 0 || Align.get_align_cnt() < AlignNum) {
  std::cerr << __PRETTY_FUNCTION__ << std::endl;
  return;
 }

 //素材
 const std::vector<std::array<std::vector<int>, 2>> *align
        = Align.get_align_num();
 const std::vector<int> &idx0 = (*align)[AlignNum][0];
 const std::vector<int> &idx1 = (*align)[AlignNum][1];
 const std::vector<Amino_Acid> *pept0
        = Unit0->get_pept(Mol0, Pept0);
 const std::vector<Amino_Acid> *pept1
        = Unit1->get_pept(Mol1, Pept1);

 std::vector<std::shared_ptr<Atom>> atom0;
 std::vector<std::shared_ptr<Atom>> atom1;

 //原子の取得（共有ポインタのコピーを作成）
 int cnt = idx0.size();
 for(int i = 0; i != cnt; ++i) {
  if(idx0[i] != -1 && idx1[i] != -1) {
  atom0.push_back((*pept0)[idx0[i]].get_atom(AA_Atom::N));
  atom1.push_back((*pept1)[idx1[i]].get_atom(AA_Atom::N));
  atom0.push_back((*pept0)[idx0[i]].get_atom(AA_Atom::C));
  atom1.push_back((*pept1)[idx1[i]].get_atom(AA_Atom::C));
  atom0.push_back((*pept0)[idx0[i]].get_atom(AA_Atom::CA));
  atom1.push_back((*pept1)[idx1[i]].get_atom(AA_Atom::CA));
  atom0.push_back((*pept0)[idx0[i]].get_atom(AA_Atom::O));
  atom1.push_back((*pept1)[idx1[i]].get_atom(AA_Atom::O));
  }
 }

 //回転行列の作成
 Align.set_pos_vect(0, &atom0);
 Align.set_pos_vect(1, &atom1);
 if(!Align.create_rotation_matrix()) {
  QMessageBox::critical(this, "エラー", "回転行列が作成できません．");
  return;
 }

 //回転
 const std::vector<std::shared_ptr<Atom>> *all_atom
        = Unit0->get_atom_vect();
 for(const auto &atom : *all_atom) {
  Align.rotate(atom->get_xyz());
 }

 WinSup->show();
 WinSup->set_view_pos(1);
 WinSup->push_wire();
 //WinSup->draw();  //WinSup.push_wire() で描画される
}

