#ifndef ___WINDOW_ALIGN_3D_H
#define ___WINDOW_ALIGN_3D_H

#include "window_align_base.h"

class Window_Align_3D : public Window_Align_Base {
 private:
  //データ構造の追加
  Builcule_Unit *Unit0;

  //GUI パーツの追加
  QLineEdit Le3DRatio;  //構造アラインメントの割合
  QLineEdit LeThres;  //構造アラインメントの閾値

  //パラメータの追加
  int Mol0;  //ユニット 0 の分子番号
  int Pept0;  //ユニット 0 のペプチド番号
  double Ratio3D;  //構造アラインメントの割合
  double Thres;  //構造アラインメントの閾値（RMS は常に正）

  //private 関数の追加
  bool capture_prm();
  void set_data();

 private slots:
  void slot_alignment();
  void slot_superimpose();

 public:
  Window_Align_3D(
        QWidget *parent,
        Builcule_Unit *Unit0,
        Builcule_Unit *unit1,
        Config_File *config,
        Window_Sup *sup);
};

#endif

