#ifndef ___WINDOW_ALIGN_BASE_H
#define ___WINDOW_ALIGN_BASE_H

/*********************************************************************
ホモロジーモデリングと構造アラインメント用の基底クラス
共通の関数や GUI パーツ
*********************************************************************/

#include "widget_show_align.h"
#include "window_sup.h"
#include <builcule/lb2/align_3d.h>
#include <builcule/lb2/builcule_unit.h>
#include <builcule/lb2/config_file.h>
#include <QButtonGroup>
#include <QComboBox>
#include <QDockWidget>
#include <QLabel>
#include <QLineEdit>
#include <QMainWindow>
#include <QMenuBar>
#include <QPushButton>
#include <QRadioButton>
#include <QVBoxLayout>

class Window_Align_Base : public QMainWindow {
 Q_OBJECT

 protected:
  //アラインメント操作と表示に関わるオブジェクト
  Align_3D Align;
  int AlignNum;  //モデリングに使うアラインメントの番号

  //Unit1 はテンプテート．内部で AA_Memo を作成するので const にできない
  Builcule_Unit *Unit1;
  Config_File *ConfigFile;  //設定


  //このクラスおよび継承クラスで設定されるパラメータ類．Align_3D に渡す
  //ペプチドの番号．vector<array<分子番号, ペプチド番号>> を 2 個
  std::array<std::vector<std::array<int, 2>>, 2> PeptNum;
  int PeptIdx0;  //コンボボックスの選択番号
  int PeptIdx1;  //コンボボックスの選択番号

  int Mol0;  //ユニット 0 の分子番号
  int Pept0;  //ユニット 0 のペプチド番号
  int Mol1;  //ユニット 1 の分子番号
  int Pept1;  //ユニット 1 のペプチド番号
  int AaRepl;  //アミノ酸置換行列の選択
  int GapIni;  //ギャップ開始ペナルティ
  int GapElg;  //ギャップ伸長ペナルティ
  int Window;  //アラインメントのウィンドウ

  //GUI パーツ
  Widget_Show_Align *WidgetAlign;  //grab で使う

  //メニューバー
  QMenuBar *MenuBar;  //QMainWindow から取得
  //以下のメニューは継承クラスでも編集できるように宣言しておく
  QMenu *MenuFile;
  QAction *ActionHide;  //Window_HM でこの前に ImportFasta を挿入する
  QMenu *MenuCalc;
  QMenu *MenuShow;

  QVBoxLayout *LayoutCentral;  //継承クラスでも使う
  QDockWidget *DockRight;  //関数内で使う

  //コンボボックス
  std::array<QComboBox, 2> PeptCombo;
  QLabel LabelC0;
  //アミノ酸置換行列の選択
  QButtonGroup GroupAaRepl;
  std::array<QRadioButton, 2> RadioButtonRepl;
  //ギャップの設定
  QLineEdit LeIni;
  QLineEdit LeElg;
  //ウィンドウの設定
  QLineEdit LeWin;

  //マウスで回転させるため，Main_Window のものを使う
  Window_Sup *WinSup;

  void create_pept_combo(int num, Builcule_Unit *unit);

 //メニューバーを基底クラスで定義すると，
 //継承クラスのインスタンスを作成した場合，スロットを基底クラスで探す
 //スロット関数を仮想関数にして定義しておき，継承クラスで定義し直す
 protected slots:
  virtual void slot_import_fasta() {}
  void slot_save_png();  //アラインメントを保存
  virtual void slot_alignment() {}  //配列か 3D か
  void trace_back();
  void show_align();
  void slot_show_score_mtx();
  virtual void slot_superimpose() {}
  virtual void slot_modeling() {}

 protected:
  //ホモロジーモデリングと構造アラインメントではペプチドのデータ構造が異なる
  //継承クラスで機能を追加する
  bool capture_prm_base();
  void set_data_base();

 public:
  Window_Align_Base(
        QWidget *parent,
        Builcule_Unit *unit1,
        Config_File *config,
        Window_Sup *sup);
};

#endif

