#include "window_hm.h"
#include <builcule/lb2/copy_pept.h>
#include <QFileDialog>
#include <QGroupBox>
#include<QMessageBox>

Window_HM::Window_HM(
        QWidget *parent,
        Builcule_Unit *unit0,
        Builcule_Unit *unit1,
        Config_File *config,
        Window_Sup*sup)
 : Window_Align_Base(parent, unit1, config, sup),
   Unit0(unit0),
   MolU1(-1),
   PeptU1(-1),
   IniU1(-1),
   TerU1(-1)
{
 QAction *action_import_fasta
    = new QAction("FASTA 形式をインポート", MenuBar);
 connect(action_import_fasta, SIGNAL(triggered()),
        this, SLOT(slot_import_fasta()));
 MenuFile->insertAction(ActionHide, action_import_fasta);

 QAction *action_modeling
    = new QAction("ホモロジーモデリング", MenuBar);
 connect(action_modeling, SIGNAL(triggered()),
        this, SLOT(slot_modeling()));
 MenuCalc->addAction(action_modeling);

 LabelC0.setText("FASTA ファイル");
 //create_combo_from_unit(1, Unit1);  //これは基底クラスで作成

 QGroupBox *gbox_str = new QGroupBox("ウィンドウの設定",this);
 QGridLayout *layout_str = new QGridLayout(gbox_str);

 QLabel *lb_win = new QLabel(this);
 lb_win->setText("ウィンドウ");

 layout_str->addWidget(lb_win, 1, 0);
 layout_str->addWidget(&LeWin, 1, 1);
 LayoutCentral->addWidget(gbox_str);

 LeWin.insert(QString::number(Window));
}

void Window_HM::slot_import_fasta() {
 //ファイル選択ダイアログボックスの作成
 QFileDialog dialog(this);
 dialog.setNameFilter("FASTA (*.fasta)");
 const std::string *file_dir = ConfigFile->get_dir_for_file();
 dialog.setDirectory(QString(file_dir->data()));
 dialog.setViewMode(QFileDialog::Detail);
 if(!dialog.exec())
  return;

 //ディレクトリ名を絶対パスで取得
 QDir qdir = dialog.directory();
 QString qdir_name = qdir.absolutePath();
 std::string dir_name = qdir_name.toStdString();
 ConfigFile->set_dir_for_file(&dir_name);

 //ファイル名を絶対パスで取得
 QStringList file_list = dialog.selectedFiles();
 QString qfile_name = file_list[0];
 std::string file_name = qfile_name.toStdString();

 //ファイルを開く
 File_IO file(&file_name);
 if(!file.import_fasta()) {
  QMessageBox::critical(this, "エラー", "インポートに失敗しました．");
  return;
 }
 FastaSequence = *file.get_fasta_seq();
 FastaComment = *file.get_fasta_comm();

 //コンボボックスのラベルを作成
 int pept_cnt = FastaComment.size();
 for(int i = 0; i != pept_cnt; ++i) {
  const std::string &str = FastaComment[i];
  int length = str.size();
  if(length < 28)
   PeptCombo[0].addItem(QString::fromStdString(str));
  else {
   std::string str2(str, 0, 28);
   PeptCombo[0].addItem(QString::fromStdString(str2));
  }
 }

 //ペプチド番号の設定
 PeptNum[0].clear();
 PeptNum[0].shrink_to_fit();
 std::array<int, 2> row {0, -1};
 for(int i = 0; i != pept_cnt; ++i) {
  row[1] = i;
  PeptNum[0].push_back(row);
 }
}

bool Window_HM::capture_prm() {
 if(!capture_prm_base())
  return false;

 //FASTA 形式では，ペプチドのみ設定
 PeptIdx0 = PeptCombo[0].currentIndex();
 if(PeptIdx0 == -1) {
  QMessageBox::critical(this, "エラー",
        "FASTA 形式が読まれていません．");
  return false;
 }

 QString str = LeWin.text();
 Window = str.toDouble();
 if(Window <= 0.0) {  //空欄だと 0.0 になる
  QMessageBox::critical(this, "エラー", "ウィンドウが異常値です．");
  return false;
 }

 return true;
}

void Window_HM::set_data() {
 set_data_base();
 Align.set_seq(0, &FastaSequence[PeptIdx0]);
 Align.set_window(Window);
}

void Window_HM::slot_alignment() {
 if(!capture_prm())
  return;
 set_data();
 Align.trace_for_homo();
 trace_back();
}

void Window_HM::slot_modeling() {
 if(Align.get_align_cnt() < 1) {
  QMessageBox::critical(this, "エラー", "まずアラインメントを計算してください．");
  return;
 }

 //ペプチド回収用の Unit1 の番号
 MolU1 = PeptNum[1][PeptIdx1][0];
 PeptU1 = PeptNum[1][PeptIdx1][1];

 //アラインメント情報
 const std::vector<std::array<std::vector<int>, 2>> *align_num
        = Align.get_align_num();
 const std::vector<std::array<std::vector<char>, 3>> *align_char
        = Align.get_alignment();

 //Unit0 の配列コード
 const std::vector<char> &code0 = (*align_char)[AlignNum][0];
 //Unit1 配列コードと配列番号．「code1 は変異の指示書」とするのでコピー
 std::vector<char> code1 = (*align_char)[AlignNum][2];
 const std::vector<int> &num1 = (*align_num)[AlignNum][1];

 //num1 をその一部として含むペプチド
 const std::vector<Amino_Acid> *pept_u1
        = Unit1->get_pept(MolU1, PeptU1);
 //num1 からテンプレートを回収するためのベクトル
 std::vector<Amino_Acid> temp_tept;

 //テンプレートペプチドの回収と「変異指示書」の作成
 Copy_Pept copy_pept;  //新品なので clear() 不要

 //指示書の作成：Unit1 のペプチドを回収．Unit0 の配列に変異
 AAMemo.clear();
 AAMemo.shrink_to_fit();
 AA_Memo memo;  //SeqNum，Code，CodeTo を記述

 IniU1 = num1[0];
 TerU1 = num1.back();
 int cnt = num1.size();
 for(int i = 0; i < cnt; ++i) {
  //pept_u1ide（テンプレート）上の配列番号．これを回収
  int idx = num1[i];

  //テンプレートが異常アミノ酸の場合は G を回収
  if(std::toupper(code1[i]) == 'X') {
   copy_pept.add_atom((*pept_u1)[idx].get_main());
  }
  //アミノ酸が一致する場合（c と p があるので，大文字に変更）すべて回収
  else if(std::toupper(code0[i]) == std::toupper(code1[i])) {
   copy_pept.add_atom((*pept_u1)[idx].get_main());
   copy_pept.add_atom((*pept_u1)[idx].get_side());
  }
  //アミノ酸が一致せず，テンプレートが G の場合，主鎖を回収
  else if(code1[i] == 'G') {
   copy_pept.add_atom((*pept_u1)[idx].get_main());
   if(code0[i] != '-') {
    memo.SeqNum = i;
    memo.Code = 'G';  //code1[i] = 'G';
    memo.CodeTo = std::toupper(code0[i]);  //'c' の場合がある
    AAMemo.push_back(memo);
   }
  }
  //アミノ酸が一致せず，テンプレートが G でない場合，A を回収
  else if(code1[i] != 'G') {
   copy_pept.add_atom((*pept_u1)[idx].get_main());
   copy_pept.add_atom((*pept_u1)[idx].get_atom(AA_Atom::CB));
  //A が回収されたので，ターゲットが - でも A でもない場合は変異
   if(code0[i] != '-' && code0[i] != 'A') {
    memo.SeqNum = i;
    memo.Code = 'A';  //code1[i] = 'A';
    memo.CodeTo = std::toupper(code0[i]);  //'c' の場合がある
    AAMemo.push_back(memo);
   }
  }
 }

 //テンプレートを Unit0 にインポート
 Unit0->clear();  //ウィンドウ内でモデリングを繰り返す場合がある
 Unit0->import_mol(copy_pept.get_pept());
 emit_hm_created();
 WinSup->show();
 WinSup->set_view_pos(1);
 WinSup->push_wire();
 //WinSup->draw();  //WinSup.push_wire() で描画される
}

