#ifndef ___WINDOW_HM_H
#define ___WINDOW_HM_H

/**********************************************************************
ホモロジーモデリングの手順
(0) アラインメントを作成
(1) Copy_Pept を利用して必要な部分を回収
(2) Builcule_Unit の import_mol でペースト
(3) アミノ酸を変異
**********************************************************************/

#include "window_align_base.h"

class Window_HM : public Window_Align_Base {
 Q_OBJECT

 private:
  //データ構造の追加
  Builcule_Unit *Unit0;
  std::vector<AA_Memo> AAMemo;  //変異指示書

  //基底クラス Window_Align_Base に一次構造を追加
  std::vector<std::string> FastaComment;
  std::vector<std::string> FastaSequence;

  //アミノ酸エディタでのテンプレート選択用の情報
  int MolU1;
  int PeptU1;
  int IniU1;  //Unit1のテンプレート開始点
  int TerU1;  //Unit1のテンプレート終了点

 signals:
  void hm_created();  //Builcule_Main に送るシグナル

 private slots:
  void emit_hm_created() { hm_created(); }

 private:
  bool capture_prm();
  void set_data();

 private slots:
  void slot_import_fasta();
  void slot_alignment();
  void slot_modeling();

 public:
  Window_HM(
        QWidget *parent,
        Builcule_Unit *unit0,
        Builcule_Unit *unit1,
        Config_File *config,
        Window_Sup *sup);
  const std::vector<AA_Memo> *get_aa_memo() const
        { return &AAMemo; }
  int get_mol_u1() const { return MolU1; }
  int get_pept_u1() const { return PeptU1; }
  int get_ini_u1() const { return IniU1; }
  int get_ter_u1() const { return TerU1; }
};

#endif

