#include "window_show_score.h"
#include <iostream>
#include <QDesktopWidget>
#include <QPainter>
#include <QScrollArea>
#include <QVBoxLayout>

/***********************************************************************
土台用ウィジェット
***********************************************************************/

Window_Show_Score::Window_Show_Score(QWidget *parent)
 : QMainWindow(parent),
   WidgetPlot(this)
{
 //ウィンドウを表示しているあいだは，メインウィンドウでの操作を禁止する
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);

 //描画領域にはスクロールバーを付ける
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);
 QScrollArea *scroll_area = new QScrollArea(widget_central);
 layout_central->addWidget(scroll_area);
 scroll_area->setWidget(&WidgetPlot);
}

void Window_Show_Score::set_score_mtx(
        const std::vector<std::vector<double>> *mtx) {
 WidgetPlot.set_score_mtx(mtx);
 set_window_size();
}

void Window_Show_Score::set_window_size() {
 //ウィンドウのサイズ．スクリーンの解像度より大きい場合は最大化
 QDesktopWidget screen;
 int s_width = screen.width();
 int s_height = screen.height();
 int d_width = WidgetPlot.get_col_cnt();//LevelMtx[0].size() +150;
 if(d_width < 250) d_width = 250;
 int d_height = WidgetPlot.get_row_cnt();//LevelMtx.size() + 200;
 if(d_height < 250) d_height = 250;

 if(s_width < d_width || s_height < d_height)
  setWindowState(windowState() ^ Qt::WindowMaximized);
 else
  setFixedSize(d_width, d_height);
}


/***********************************************************************
描画用ウィジェット
***********************************************************************/

Widget_Plot::Widget_Plot(QWidget *parent)
 : QWidget(parent),
   Margin(50)
{
 setMinimumSize(1, 1);  //何らかの値を設定しておかないと描画されない
 setStyleSheet("background-color:white");

 Color[0] = Qt::blue;
 Color[1] = Qt::cyan;
 Color[2] = Qt::green;
 Color[3] = Qt::yellow;
 Color[4] = Qt::red;
}

void Widget_Plot::set_score_mtx(
        const std::vector<std::vector<double>> *mtx) {
 if(mtx->empty()) {
  std::cerr << __PRETTY_FUNCTION__ << std::endl;
  return;
 }

 //5 段階にレベルを設定．色分けの基準とする
 double max = 0.0;
 for(const auto &row : *mtx)
  for(double val : row)
   if(max < val) max = val;
 if(max == 0.0) {
  std::cerr << __PRETTY_FUNCTION__ << std::endl;
  return;
 }
 double lv1 = max / 5.0;
 double lv2 = lv1 * 2.0;
 double lv3 = lv1 * 3.0;
 double lv4 = lv1 * 4.0;
 int row_cnt = mtx->size() - 1;
 int col_cnt = (*mtx)[0].size() - 1;
 LevelMtx.assign(row_cnt, std::vector<int>(col_cnt, 0));
 for(int i = 0; i != row_cnt; ++i)
  for(int j = 0; j != col_cnt; ++j) {
   if((*mtx)[i][j] > lv4) LevelMtx[i][j] = 4;
   else if((*mtx)[i][j] > lv3) LevelMtx[i][j] = 3;
   else if((*mtx)[i][j] > lv2) LevelMtx[i][j] = 2;
   else if((*mtx)[i][j] > lv1) LevelMtx[i][j] = 1;
  }
}

void Widget_Plot::paintEvent(QPaintEvent *) {
 if(LevelMtx.empty())
  return;

 draw_frame();
 draw_dot();
}


void Widget_Plot::draw_frame() {
 QPainter painter(this);

 int x0 = Margin;
 int y0 = Margin;
 int y_width = LevelMtx.size();
 int x_width = LevelMtx[0].size();
 resize(x_width + Margin * 2, y_width + Margin * 2);

 //枠
 painter.drawRect(x0, y0, x_width, y_width);

 //目盛
 int scale = 100;
 int scale_cnt = x_width / scale;  //100 ドットごとに目盛を打つ
 for(int i = 1; i <= scale_cnt; ++i) {
  painter.drawLine(x0 + scale * i, y0, x0 + scale * i, y0 - 10);
  painter.drawLine(x0 + scale * i, y0 + y_width, x0 + scale * i, y0 + y_width + 10);
 }

 scale_cnt = y_width / scale;
 for(int i = 1; i <= scale_cnt; ++i) {
  painter.drawLine(x0, y0 + scale * i, x0 - 10, y0 + scale * i);
  painter.drawLine(x0 + x_width, y0 + scale * i, x0 + x_width + 10, y0 + scale * i);
 }
}

void Widget_Plot::draw_dot() {
 QPainter painter(this);

 int x0 = Margin;
 int y0 = Margin;
 int x_pos = 0;
 int y_pos = 0;
 int y_cnt = LevelMtx.size();
 int x_cnt = LevelMtx[0].size();
 for(int i = 0; i < y_cnt; ++i) {
  y_pos = y0 + i;
  for(int j = 0; j < x_cnt; ++j) {
   x_pos = x0 + j;
   int lv = LevelMtx[i][j];
   painter.setPen(Color[lv]);
   painter.drawPoint(x_pos, y_pos);
  }
 }
}
