#ifndef ___WIDGET_SCORE_H
#define ___WIDGET_SCORE_H

#include <QMainWindow>

/***********************************************************************
描画用ウィジェット
***********************************************************************/

class Widget_Plot : public QWidget {
 private:
  std::vector<std::vector<int>> LevelMtx;
  std::array<QColor, 5> Color;
  int Margin;

  void paintEvent(QPaintEvent *) override;

 public:
  Widget_Plot(QWidget *parent);

  int get_row_cnt() const { return LevelMtx.size();}
  int get_col_cnt() const
        { return LevelMtx.empty() ? 0 : LevelMtx[0].size();}
  void set_score_mtx(const std::vector<std::vector<double>> *mtx);
  void draw_frame();
  void draw_dot();
};


/***********************************************************************
土台用ウィジェット
***********************************************************************/

class Window_Show_Score : public QMainWindow {
 private:
  Widget_Plot WidgetPlot;

  void set_window_size();

 public:
  Window_Show_Score(QWidget *parent);
  void set_score_mtx(
        const std::vector<std::vector<double>> *mtx);
};

#endif

