#include "window_sup.h"
#include <QVBoxLayout>

Window_Sup::Window_Sup(QWidget *parent, Unit *unit0, Unit *unit1)
 : QMainWindow(parent),
   UnitPtr{unit0, unit1},
   ViewPos(1),
   MenuBar(menuBar()),
   WidgetSup(this, unit0, unit1)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 QMenu *menuFile = new QMenu("ファイル(&F)", MenuBar);
 MenuBar->addMenu(menuFile);

 QAction *actionQuit = new QAction("閉じる(&C)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 QMenu *menuView = new QMenu("表示(&V)", MenuBar);
 MenuBar->addMenu(menuView);

 QAction *actionViewPos
        = new QAction("視点を変更(&C)", menuFile);
 menuView->addAction(actionViewPos);
 connect(actionViewPos, SIGNAL(triggered()),
        this, SLOT(slot_view_pos()));

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //描画ウィジェット
 layout_central->addWidget(&WidgetSup);
 WidgetSup.setFocus();
 connect(&WidgetSup, SIGNAL(sig_drawed()),
        this, SLOT(emit_drawed()));
}

void Window_Sup::slot_view_pos() {
 ViewPos = !ViewPos;
 set_view_pos(ViewPos);
}

void Window_Sup::set_view_pos(int unit) {
 if(!(unit == 0 || unit == 1)) {
  std::cout << __PRETTY_FUNCTION__ << std::endl;
  return;
 }

 //両ユニット同時回転により片ユニットの中心が移動する
 //センタリング後にこのウィンドウを開くと良い
 //とりあえず対象ユニットの再設定
 UnitPtr[unit]->calc_unit_center_radius();
 UnitPtr[unit]->init_rotation_center();
 ViewPos = unit;

 const Eigen::Vector3d *center = UnitPtr[unit]->get_center();
 double radius = UnitPtr[unit]->get_radius();
 WidgetSup.set_view_prm(center, radius);

 center = UnitPtr[unit]->get_rotation_center();
 UnitPtr[!unit]->set_rotation_center(center);
}

