#include "aa_color_draw.h"

AA_Color_Draw::AA_Color_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm)
 : Draw_Base(parent, atom, mol, serial, prm)
{
 AACodeMap[0]  = 'A'; AACodeMap[1]  = 'R'; AACodeMap[2]  = 'N';
 AACodeMap[3]  = 'D'; AACodeMap[4]  = 'C'; AACodeMap[5]  = 'G';
 AACodeMap[6]  = 'Q'; AACodeMap[7]  = 'E'; AACodeMap[8]  = 'H';
 AACodeMap[9]  = 'I'; AACodeMap[10] = 'L'; AACodeMap[11] = 'K';
 AACodeMap[12] = 'M'; AACodeMap[13] = 'F'; AACodeMap[14] = 'P';
 AACodeMap[15] = 'S'; AACodeMap[16] = 'T'; AACodeMap[17] = 'W';
 AACodeMap[18] = 'Y'; AACodeMap[19] = 'V';

 AAColorMap[0]  = 3; AAColorMap[1]  = 1; AAColorMap[2]  = 4;
 AAColorMap[3]  = 0; AAColorMap[4]  = 2; AAColorMap[5]  = 4;
 AAColorMap[6]  = 4; AAColorMap[7]  = 0; AAColorMap[8]  = 1;
 AAColorMap[9]  = 3; AAColorMap[10] = 3; AAColorMap[11] = 1;
 AAColorMap[12] = 3; AAColorMap[13] = 5; AAColorMap[14] = 3;
 AAColorMap[15] = 4; AAColorMap[16] = 4; AAColorMap[17] = 5;
 AAColorMap[18] = 5; AAColorMap[19] = 3;
}

void AA_Color_Draw::clear() {
 SphereForDraw.clear();
 SphereForDraw.shrink_to_fit();
}

void AA_Color_Draw::create_objects() {
 create_cylinder();
}

void AA_Color_Draw::select(const std::vector<int> *aa) {
 SphereForDraw.clear();
 SphereForDraw.shrink_to_fit();

 for(int num : *aa) {
  push_aa_atom(AACodeMap[num], AAColorMap[num]);
  if(num == 4)
   push_aa_atom('c', 2);
  if(num == 14)
   push_aa_atom('p', 4);
 }
}

void AA_Color_Draw::push_aa_atom(char code, int color) {
 for(const Mol &mol : *MolVect) {
  const std::vector<std::vector<Amino_Acid>> &pept_vect
        = mol.aaTable;
  for(const std::vector<Amino_Acid> &pept : pept_vect) {
   for(const Amino_Acid &aa : pept) {
    if(aa.Code1 == code)
     create_sphere(aa.allSerial, color);
   }
  }
 }
}

void AA_Color_Draw::create_sphere(const std::vector<int> &serial, int color) {
 Sphere sphere;

 const std::array<double, ELMT_CNT> &cov_radius
        = Atom_Distance().cov_radius();

 for(int num : serial) {
  int idx = SerialToIdx->at(num);
  const Atom &atom = (*AtomVect)[idx];

  sphere.Serial = num;
  sphere.Pos = &atom.XYZ;
  sphere.Radius = cov_radius[atom.Elmt];

  for(int j = 0; j < 4; ++j)
   sphere.Color[j] = molColor[color][j];

  SphereForDraw.push_back(sphere);
 }
}

void AA_Color_Draw::create_cylinder() {
 CylinderForDraw.clear();
 CylinderForDraw.shrink_to_fit();

 Cylinder cylinder;

 for(const Atom &atom : *AtomVect) {
  cylinder.Pos0 = &atom.XYZ;
  for(int serial1 : atom.BondUp) {
   int idx1 = SerialToIdx->at(serial1);
   const Atom &atom1 = (*AtomVect)[idx1];
   cylinder.Pos1 = &(atom1.XYZ);
   CylinderForDraw.push_back(cylinder);
  }
 }
}

