#ifndef ___AA_COLOR_DRAW_H
#define ___AA_COLOR_DRAW_H

#include "draw_base.h"

class AA_Color_Draw : public Draw_Base {
 private:
  std::map<int, char> AACodeMap;
  std::map<int, char> AAColorMap;

  void create_cylinder();
  void push_aa_atom(char code, int color);
  void create_sphere(const std::vector<int> &serial, int color);

 public:
  AA_Color_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm);

  void select(const std::vector<int> *aa);
  void clear();
  void create_objects();
};

#endif
