#include "aa_color_window.h"
#include <QBoxLayout>
#include <QMenuBar>

AA_Color_Window::AA_Color_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm)
 : QMainWindow(parent),
   SharedPrm(prm),
   AAColorDraw(this, atom, mol, serial, prm)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 QMenuBar *menu_Bar(menuBar());
 QMenu *menuFile = new QMenu("ファイル(&F)", menu_Bar);
 menu_Bar->addMenu(menuFile);

 QAction *actionQuit = new QAction("終了(&Q)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QHBoxLayout *layout_central = new QHBoxLayout(widget_central);

 //描画ウィジェット
 layout_central->addWidget(&AAColorDraw);
 AAColorDraw.setFocus();

 //設定ウィジェット
 QWidget *setting_widget = new QWidget(this);
 setting_widget->setMaximumWidth(150);

 layout_central->addWidget(setting_widget);
 QVBoxLayout *setting_layout = new QVBoxLayout(setting_widget);
 setting_layout->setAlignment(Qt::AlignTop);

 for(int i = 0; i < 20; ++i) {
  ButtonArray[i] = new QPushButton(setting_widget);
  ButtonArray[i]->setText(QString(AAName[i].data()));
  ButtonArray[i]->setCheckable(true);
  setting_layout->addWidget(ButtonArray[i]);
 }

 QPushButton *pb_clear = new QPushButton("解除", setting_widget);
 setting_layout->addWidget(pb_clear);
 connect(pb_clear,
        SIGNAL(clicked()),
        this,
        SLOT(clear()));

 QPushButton *pb_detect = new QPushButton("検知", setting_widget);
 setting_layout->addWidget(pb_detect);
 connect(pb_detect,
        SIGNAL(clicked()),
        this,
        SLOT(detect()));

 //上の設定値で初期描画
 AAColorDraw.create_objects();
}

void AA_Color_Window::clear() {
 for(int i = 0; i < 20; ++i)
  if(ButtonArray[i]->isChecked())
   ButtonArray[i]->setChecked(false);

 AAColorDraw.clear();
 AAColorDraw.create_objects();
 AAColorDraw.repaint();
}

void AA_Color_Window::detect() {
 std::vector<int> checked;
 for(int i = 0; i < 20; ++i)
  if(ButtonArray[i]->isChecked())
   checked.push_back(i);

 AAColorDraw.select(&checked);
 AAColorDraw.create_objects();
 AAColorDraw.repaint();
}

void AA_Color_Window::keyPressEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X) {
  SharedPrm->KeyX = true;
  SharedPrm->KeyZ = false;
 }
 else if(event->key() == Qt::Key_Z) {
  SharedPrm->KeyX = false;
  SharedPrm->KeyZ = true;
 }
}

void AA_Color_Window::keyReleaseEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X)
  SharedPrm->KeyX = false;
 else if(event->key() == Qt::Key_Z)
  SharedPrm->KeyZ = false;
}

