#ifndef ___AA_COLOR_WINDOW_H
#define ___AA_COLOR_WINDOW_H

#include "aa_color_draw.h"
#include <QMainWindow>
#include <QPushButton>

class AA_Color_Window : public QMainWindow {
 Q_OBJECT

 private:
  Shared_Prm *SharedPrm;
  AA_Color_Draw AAColorDraw;
  std::array<QPushButton*, 20> ButtonArray;

  void keyPressEvent(QKeyEvent *event) override;
  void keyReleaseEvent(QKeyEvent *event) override;

 private slots:
  void clear();
  void detect();

 public:
  AA_Color_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm);
};

#endif
