#ifndef ___ALIGN3D_H
#define ___ALIGN3D_H

#include "global.h"
#include <builcule/amino_acid.h>
#include <builcule/atom.h>
#include <builcule/dynamic.h>
#include <builcule/libbuilcule_global.h>
#include <builcule/superimpose.h>

class Align3D {
 private:
  Shared_Prm *SharedPrm;
  Dynamic_Programming Dynamic;
  std::vector<TB_Point> TBPoint;
  Superimpose Sup;  //構造アラインメント用

  //パラメータ

  //アミノ酸置換行列を数字で設定
  //アミノ酸置換行列へのポインタ
  const std::array<std::array<double, 20>, 20> *aaReplMtx;
  const std::map<char, int> &aaOrder;  //libluilcule_global.h で定義
  //アミノ酸置換行列の要素の最大値．スコアの計算に使う
  double aaReplMaxVal;

  int Window;
  double aaWeight;
  double Threshold;
  bool Harr;

  //データ
  std::array<const std::vector<char> *, 2> OrigSeq;
  //orgXYZ はアミノ酸残基ごとに小分けしてあるので 2 次元配列となっている
  std::array<const std::vector<std::vector<Eigen::Vector3d>>*, 2> orgXYZ;
  //orgXYZ を Window ごとに再編したもの
  std::array<std::vector<std::vector<Eigen::Vector3d>>, 2> winXYZ;

  std::array<std::vector<char>, 2> Alignment;

  //パラメータ操作関数
  double gain_aa(int pos0, int pos1);
  double gain_3d(int pos0, int pos1);

 public:
  Align3D(Shared_Prm *prm);

  void clear();

  //ウィンドウ作成時に必要な情報
  void set_window(int win) { Window = win; }
  void set_threshold(int thres) { Threshold = thres; }
  void set_aa_weight(double weight) { aaWeight = weight; }

  int get_window() { return Window; }
  double get_threshold() { return Threshold; }
  double get_aa_weight() { return aaWeight; }

  void set_seq(const std::vector<char> *seq, int layer)
        { OrigSeq[layer] = seq; }
  void set_xyz(const std::vector<std::vector<Eigen::Vector3d>> *xyz, int layer)
        { orgXYZ[layer] = xyz; }

  //計算
  void init();
  void trace();
  void prepare_traceback_point();

  //引数は n 番めのトレースバックポイント（現在は最大スコアのポイントのみ）
  void traceback(int num = 0);

  void calc_harr();

  //結果
  const std::vector<std::vector<double>> *score_mtx()
      { return Dynamic.get_score_mtx(); }
  const std::array<std::vector<char>, 2> *get_alignment()
      { return &Alignment; }

  int get_aligned_ini(int unit)
        { return Dynamic.get_aligned_ini(unit); }
  int get_aligned_ter(int unit)
        { return Dynamic.get_aligned_ter(unit); }
  int get_score(int num)
        { return Dynamic.get_score(num); }

  const std::array<std::vector<int>, 2> *get_aligned_aa_num()
    { return Dynamic.get_aligned_num(); }
};

#endif
