#include "align_window.h"
#include "seq_window.h"
#include <QBoxLayout>
#include <QCloseEvent>
#include <QGroupBox>
#include <QLabel>
#include <QMessageBox>
//#include <memory>  //どこで使ったのか忘れた

Align_Window::Align_Window(QWidget *parent, Shared_Prm *prm, Detrial_Unit *u0, Detrial_Unit *u1)
 : QMainWindow(parent),
   SharedPrm(prm),
   dUnit{u0, u1},
   MolNum{-1, -1},
   PeptNum{-1, -1},
   Align_3D(prm)
{
 //ウィンドウを表示しているあいだは，メインウィンドウでの操作を禁止する
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //セントラルウィジェット
 setWindowTitle("アラインメントの条件設定");
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //ペプチド選択用コンボボックスを 2 個横縦びに
 QGroupBox *gbox_pept = new QGroupBox("ペプチドの選択", this);
 QGridLayout *layout_pept = new QGridLayout(gbox_pept);

 QLabel *label_c0 = new QLabel(this);
 label_c0->setText("レイヤ 0");
 layout_pept->addWidget(label_c0, 0, 0);
 layout_pept->addWidget(&PeptCombo[0], 0, 1);

 QLabel *label_c1 = new QLabel(this);
 label_c1->setText("レイヤ 1");
 layout_pept->addWidget(label_c1, 1, 0);
 layout_pept->addWidget(&PeptCombo[1], 1, 1);

 //アミノ酸置換行列．後で縦並びに「ウェイト値」と「置換行列の選択」を配列
 QGroupBox *gbox_repl = new QGroupBox("アミノ酸置換行列",this);
 QVBoxLayout *layout_repl = new QVBoxLayout(gbox_repl);

 //置換行列の選択
 QWidget *widget_repl_radio = new QWidget(this);
 QHBoxLayout *layout_repl_radio = new QHBoxLayout(widget_repl_radio);
 layout_repl->addWidget(widget_repl_radio);

 RadioButtonPAM.setText("PAM250");
 layout_repl_radio->addWidget(&RadioButtonPAM);
 groupAaRepl.addButton(&RadioButtonPAM, 0);

 RadioButtonBLOSUM.setText("BLOSUM62");
 layout_repl_radio->addWidget(&RadioButtonBLOSUM);
 groupAaRepl.addButton(&RadioButtonBLOSUM, 1);

 //ウェイト値の設定．ラベルとラインエディタを横並びに
 QWidget *widget_weight = new QWidget(this);
 QHBoxLayout *layout_weight = new QHBoxLayout(widget_weight);
 layout_repl->addWidget(widget_weight);

 QLabel *label_weight = new QLabel(this);
 label_weight->setText("ウェイト");
 layout_weight->addWidget(label_weight);

 layout_weight->addWidget(&leAaWeight);

 //コンストラクタ引数には，アミノ酸配列が含まれる
 create_pept_combo(0);
 create_pept_combo(1);

 //アラインメントの条件設定用オブジェクト
 QGroupBox *gbox_gap = new QGroupBox("パラメータ", this);
 QGridLayout *layout_gap = new QGridLayout(gbox_gap);

 QLabel *lb_ini = new QLabel(this);
 lb_ini->setText("ギャップ開始ペナルティ");

 QLabel *lb_elong = new QLabel(this);
 lb_elong->setText("ギャップ伸長ペナルティ");

 QLabel *lb_win = new QLabel(this);
 lb_win->setText("ウィンドウ");

 QLabel *lb_thres = new QLabel(this);
 lb_thres->setText("閾値");

 layout_gap->addWidget(lb_win, 0, 0);
 layout_gap->addWidget(&leWin, 0, 1);
 layout_gap->addWidget(lb_ini, 1, 0);
 layout_gap->addWidget(&leIni, 1, 1);
 layout_gap->addWidget(lb_elong, 2, 0);
 layout_gap->addWidget(&leElg, 2, 1);
 layout_gap->addWidget(lb_thres, 3, 0);
 layout_gap->addWidget(&leThres, 3, 1);

 QWidget *button_widget = new QWidget(this);
 QGridLayout *layout_button = new QGridLayout(button_widget);

 QPushButton *pb_create_align = new QPushButton("アラインメントを計算", this);
 connect(pb_create_align, SIGNAL(clicked()), this, SLOT(slot_calc_align()));

 QPushButton *pb_harr = new QPushButton("ドットプロットを計算", this);
 connect(pb_harr, SIGNAL(clicked()), this, SLOT(slot_calc_harr()));

 QPushButton *pb_seq = new QPushButton("アラインメントの表示", this);
 connect(pb_seq, SIGNAL(clicked()), this, SLOT(slot_show_alignment()));

 QPushButton *pb_plot = new QPushButton("スコア行列をプロット", this);
 connect(pb_plot, SIGNAL(clicked()), this, SLOT(slot_plot_score_mtx()));

 QPushButton *pb_super = new QPushButton("重ね合わせ", this);
 connect(pb_super, SIGNAL(clicked()), this, SLOT(slot_superimpose_by_align()));

 QPushButton *pb_close = new QPushButton("閉じる", this);
 connect(pb_close, SIGNAL(clicked()), this, SLOT(hide()));
 layout_button->addWidget(pb_create_align, 0, 0);
 layout_button->addWidget(pb_harr, 0, 1);
 layout_button->addWidget(pb_seq, 1, 0);
 layout_button->addWidget(pb_plot, 1, 1);
 layout_button->addWidget(pb_super, 2, 0);
 layout_button->addWidget(pb_close, 2, 1);

 //ウィンドウ全体のレイアウト
 layout_central->addWidget(gbox_pept);
 layout_central->addWidget(gbox_repl);
 layout_central->addWidget(gbox_gap);
 layout_central->addWidget(button_widget);

 //Align_3D の値を表示
 leAaWeight.insert(QString::number(Align_3D.get_aa_weight(), 'd', 1));
 leIni.insert(QString::number(SharedPrm->GapIni));
 leElg.insert(QString::number(SharedPrm->GapElg));
 leWin.insert(QString::number(Align_3D.get_window()));
 leThres.insert(QString::number(Align_3D.get_threshold(), 'd', 1));

 if(SharedPrm->AaRepl == 0)
  RadioButtonPAM.setChecked(true);
 else
  RadioButtonBLOSUM.setChecked(true);

 show();
}

void Align_Window::hideEvent(QHideEvent *event) {
 windowPlot.close();
 event->accept();
}

void Align_Window::create_pept_combo(int unit) {
 numTable[unit].clear();
 numTable[unit].shrink_to_fit();

 std::array<int, 3> row {-1, -1, -1};
 const std::vector<Mol> *mol_vect = dUnit[unit]->mol_vect();
 int mol_cnt = mol_vect->size();
 for(int i = 0; i < mol_cnt; ++i) {
  row[0] = i;
  int pept_cnt = (*mol_vect)[i].aaTable.size();
  for(int j = 0; j < pept_cnt; ++j) {
   row[1] = j;
   int aa_cnt = (*mol_vect)[i].aaTable[j].size();
   row[2] = aa_cnt;  //Window の設定用
   numTable[unit].push_back(row);
  }
 }

 PeptCombo[unit].clear();
 for(const std::array<int, 3> &row : numTable[unit])
  PeptCombo[unit].addItem(QString("分子番号：") +
        QString::number(row[0]) + QString(" ペプチド番号：") +
        QString::number(row[1]));
}

void Align_Window::confirm_prm() {
 QString str = leWin.text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "ウィンドウが空欄です．");
  return;
 }

 int win = str.toInt();
 if(win < 0) {
  QMessageBox::critical(this, "エラー", "ウィンドウが負数です．");
  return;
 }
 int idx_0 = PeptCombo[0].currentIndex();
 if(numTable[0][idx_0][2] < win) {
  QMessageBox::critical(this, "エラー", "レイヤ 0 の ウィンドウが大きすぎます．");
  return;
 }
 int idx_1 = PeptCombo[1].currentIndex();
 if(numTable[1][idx_1][2] < win) {
  QMessageBox::critical(this, "エラー", "レイヤ 1 の ウィンドウが大きすぎます．");
  return;
 }

 str = leIni.text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "ギャップ開始ペナルティが空欄です．");
  return;
 }
 double ini = str.toDouble();
 if(ini < 0.0) {
  QMessageBox::critical(this, "エラー", "ギャップ開始ペナルティが負数です．");
  return;
 }

 str = leElg.text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "ギャップ伸長ペナルティが空欄です．");
  return;
 }
 double elg = str.toDouble();
 if(elg < 0.0) {
  QMessageBox::critical(this, "エラー", "ギャップ伸長ペナルティが負数です．");
  return;
 }

 str = leThres.text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "閾値が空欄です．");
  return;
 }
 double thres = str.toDouble();
 if(thres < 0.0) {
  QMessageBox::critical(this, "エラー", "閾値が負数です．");
  return;
 }

 str = leAaWeight.text();
 if(str.isEmpty()) {
  QMessageBox::critical(this, "エラー", "ウェイトが空欄です．");
  return;
 }
 double weight = str.toDouble();
 if(weight < 0.0 || 1.0 < weight) {
  QMessageBox::critical(this, "エラー", "ウェイトが異常値です．");
  return;
 }

 MolNum[0] = numTable[0][idx_0][0];
 PeptNum[0] = numTable[0][idx_0][1];
 MolNum[1] = numTable[1][idx_1][0];
 PeptNum[1] = numTable[1][idx_1][1];

 Align_3D.set_window(win);
 SharedPrm->GapIni = ini;
 SharedPrm->GapElg = elg;
 SharedPrm->AaRepl = groupAaRepl.checkedId();
 Align_3D.set_threshold(thres);
 Align_3D.set_aa_weight(weight);
}

void Align_Window::slot_calc_harr() {
 Align_3D.clear();
 confirm_prm();

 const std::vector<char> *seq0
     = dUnit[0]->get_aa_seq(MolNum[0], PeptNum[0]);
 const std::vector<char> *seq1
     = dUnit[1]->get_aa_seq(MolNum[1], PeptNum[1]);

 dUnit[0]->create_xyz_for_align3d(MolNum[0], PeptNum[0]);
 dUnit[1]->create_xyz_for_align3d(MolNum[1], PeptNum[1]);

 Align_3D.set_seq(seq0, 0);
 Align_3D.set_seq(seq1, 1);
 Align_3D.set_xyz(dUnit[0]->xyz_for_align3d(), 0);
 Align_3D.set_xyz(dUnit[1]->xyz_for_align3d(), 1);
 Align_3D.init();
 Align_3D.calc_harr();
//プロットは，別途ウィンドウ上の「スコアマトリックスを表示」ボタンをクリック
}

void Align_Window::slot_calc_align() {
 Align_3D.clear();
 confirm_prm();

 //座標は，dUnit でコピーを作成し，それを Align に渡している
 const std::vector<char> *seq0
     = dUnit[0]->get_aa_seq(MolNum[0], PeptNum[0]);
 const std::vector<char> *seq1
     = dUnit[1]->get_aa_seq(MolNum[1], PeptNum[1]);
 dUnit[0]->create_xyz_for_align3d(MolNum[0], PeptNum[0]);
 dUnit[1]->create_xyz_for_align3d(MolNum[1], PeptNum[1]);

 Align_3D.set_seq(seq0, 0);
 Align_3D.set_seq(seq1, 1);
 Align_3D.set_xyz(dUnit[0]->xyz_for_align3d(), 0);
 Align_3D.set_xyz(dUnit[1]->xyz_for_align3d(), 1);
 Align_3D.init();
 Align_3D.trace();
 Align_3D.prepare_traceback_point();

 //トレースバック．アラインメントされた配列は align3d に保管される
 //今の所，最高スコアの点からトレースバックのみ
 Align_3D.traceback(0);

 //アミノ酸の選択等は Detrial_Main で処理
 emit_align_calced();
}

void Align_Window::slot_plot_score_mtx() {
 const std::vector<std::vector<double>> *mtx
        = Align_3D.score_mtx();
 if(mtx->empty()) {
  QMessageBox::information(this, "情報", "スコア行列が作成されていません．");
  return;
 }

 windowPlot.set_score_mtx(mtx);
 windowPlot.set_window_size();
 windowPlot.show();
 if(windowPlot.isVisible())
  windowPlot.replot();
}

void Align_Window::slot_show_alignment() {
 const std::array<std::vector<char>, 2> *align
        = Align_3D.get_alignment();
 if((*align)[0].empty()) {
  QMessageBox::warning(this, "警告", "アラインメントが作成されていません．");
  return;
 }

 Seq_Window *seq_window = new Seq_Window;

 for(int i = 0; i != 2; ++i) {
  seq_window->set_info_mol(
    i,
    &SharedPrm->fileName[i],
    MolNum[i],
    PeptNum[i],
    Align_3D.get_aligned_ini(i),
    Align_3D.get_aligned_ter(i));
 }

 seq_window->set_info_condition(
   Align_3D.get_score(0),
   Align_3D.get_window(),
   SharedPrm->GapIni,
   SharedPrm->GapElg,
   Align_3D.get_threshold(),
   SharedPrm->AaRepl,
   Align_3D.get_aa_weight());

 seq_window->set_align(Align_3D.get_alignment());
 seq_window->show();
}


void Align_Window::slot_superimpose_by_align()
{
 const std::array<std::vector<int>, 2> *aa_num
        = Align_3D.get_aligned_aa_num();
 if((*aa_num)[0].empty())
  return;

 //Unit1 を基準にして，Unit0 を回転
 //こちらを 平行移動して回転
 std::vector<Eigen::Vector3d> target;
 dUnit[0]->get_xyz_for_superimpose(
        0,
        MolNum[0],
        PeptNum[0],
        &(*aa_num),
        &target);

 //こちらは動かさない
 std::vector<Eigen::Vector3d> standard;
 dUnit[1]->get_xyz_for_superimpose(
        1,
        MolNum[1],
        PeptNum[1],
        &(*aa_num),
        &standard);

 //アラインメントされた領域と，その中心を設置
 Sup.set_target(&target);
 Sup.set_standard(&standard);
 const Eigen::Vector3d *align_center0 = Sup.get_align_center(0);
 const Eigen::Vector3d *align_center1 = Sup.get_align_center(1);

 //target の中心を standard 中心に移動
 unitAffine[0].move(align_center0, align_center1);
 //回転行列を作成して重ね合わせ
  if(!Sup.create_rotation_matrix())
   return;
 Sup.rotate(dUnit[0]->atom_vect());

 //Builcule_Main で Builcule_Draw を再描画
 unitAffine[1].calc_center();
 unitAffine[0].set_center(unitAffine[1].get_center());
 emit_superimpose_by_align();
}

