#ifndef ___ALIGN_WINDOW_H
#define ___ALIGN_WINDOW_H

#include "align3d.h"
#include "detrial_unit.h"
#include "plot_window.h"
#include <builcule/superimpose.h>
#include <array>
#include <QButtonGroup>
#include <QComboBox>
#include <QLineEdit>
#include <QMainWindow>
#include <QPushButton>
#include <QRadioButton>

class Align_Window : public QMainWindow {
 Q_OBJECT  //これがないとコンパイルエラーになる

 private:
  //コンストラクタ引数とするオブジェクト
  Shared_Prm *SharedPrm;
  std::array<Detrial_Unit *, 2> dUnit;

 signals:  //送信するシグナル
  void align_calced();
  void superimpose_by_align();

 public slots:  //シグナルを送信する関数
  void emit_superimpose_by_align() { superimpose_by_align(); }
  void emit_align_calced() { align_calced(); }


 private:
  std::array<std::vector<std::array<int, 3>>, 2> numTable; //コンボボックスや Window の設定
  std::array<int, 2> MolNum;
  std::array<int, 2> PeptNum;

  Align3D Align_3D;
  Superimpose Sup;  //重ね合わせ用．Align3D に構造アラインメント用がある

  std::array<QComboBox, 2> PeptCombo;
  QLineEdit leWin;
  QLineEdit leIni;
  QLineEdit leElg;
  QLineEdit leAaWeight;
  QButtonGroup groupAaRepl;
  QRadioButton RadioButtonPAM;
  QRadioButton RadioButtonBLOSUM;
  QLineEdit leThres;

  //Window_Plot は条件を変えて表示を繰り返す場合がありそうなので 1 個だけ作成して再表示する．なお，Seq_Window は複数のアラインメントを表示できるのがよさそうなので，その都度 new 演算子で作成する
  Plot_Window windowPlot;
  void hideEvent(QHideEvent *event) override;
  void create_pept_combo(int unit);
  void confirm_prm();

 private slots:
  void slot_calc_align();
  void slot_calc_harr();
  void slot_plot_score_mtx();
  void slot_show_alignment();
  void slot_superimpose_by_align();

 public:
  Align_Window(QWidget *parent, Shared_Prm *prm, Detrial_Unit *u0, Detrial_Unit *u1);

  int mol_num(int layer) { return MolNum[layer]; }
  int pept_num(int layer) { return PeptNum[layer]; }
  const std::array<std::vector<int>, 2> *get_aligned_aa_num()
        { return Align_3D.get_aligned_aa_num(); }
};

#endif
