#include "charge_draw.h"

Charge_Draw::Charge_Draw(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        const Shared_Prm *prm)
 : Draw_Base(parent, atom, mol, serial, prm)
{
 create_objects();
}

void Charge_Draw::create_objects() {
 create_sphere();
 create_wire();
}

void Charge_Draw::create_wire() {
 WireForDraw.clear();
 WireForDraw.shrink_to_fit();

 Wire wire;
 for(const Mol &mol : *MolVect) {
  const std::vector<int> &serial_vect = mol.atomSerial;
  for(int serial0 : serial_vect) {
   int idx0 = SerialToIdx->at(serial0);
   const Atom &atom0 = (*AtomVect)[idx0];
   const std::vector<int> &bond = atom0.BondUp;
   for(int serial1 : bond) {
    int idx1 = SerialToIdx->at(serial1);
    wire.Pos0 = &(*AtomVect)[idx0].XYZ;
    wire.Pos1 = &(*AtomVect)[idx1].XYZ;
    for(int j = 0; j != 3; ++j)
     wire.Color[j] = molColor[6][j];

    WireForDraw.push_back(wire);
   }
  }
 }
}

void Charge_Draw::create_sphere() {

 SphereForDraw.clear();
 SphereForDraw.shrink_to_fit();

 Sphere sphere;

 int atom_cnt = AtomVect->size();
 for(int i = 0; i < atom_cnt; ++i) {
  const Atom &atom = (*AtomVect)[i];
  sphere.Serial = atom.serialNum;
  sphere.Pos = &atom.XYZ;
  sphere.Radius = abs(atom.Charge);

  //深度に応じてカラーリング
  if(atom.Charge < 0.0) {
   sphere.Color[0] = 1.0;
   sphere.Color[1] = 0.0;
   sphere.Color[2] = 0.0;
  }
  else {
   sphere.Color[0] = 0.0;
   sphere.Color[1] = 0.0;
   sphere.Color[2] = 1.0;
  }

  SphereForDraw.push_back(sphere);
 }
}
