#include "charge_window.h"
#include <QBoxLayout>
#include <QLabel>
#include <QMenuBar>
#include <QMessageBox>
#include <QPushButton>

Charge_Window::Charge_Window(QWidget *parent,
        std::vector<Atom> *atom,
        const std::vector<Mol> *mol,
        const std::map<int, int> *serial,
        Shared_Prm *prm)
 : QMainWindow(parent),
   SharedPrm(prm),
   ChargeDraw(this, atom, mol, serial, prm)
{
 setWindowModality(Qt::WindowModal);
 setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint);

 //メニューバー
 QMenuBar *menu_Bar(menuBar());
 QMenu *menuFile = new QMenu("ファイル(&F)", menu_Bar);
 menu_Bar->addMenu(menuFile);

 QAction *actionQuit = new QAction("終了(&Q)", menuFile);
 menuFile->addAction(actionQuit);
 connect(actionQuit, SIGNAL(triggered()), this, SLOT(close()));

 //セントラルウィジェット
 QWidget *widget_central = new QWidget(this);
 setCentralWidget(widget_central);
 QVBoxLayout *layout_central = new QVBoxLayout(widget_central);

 //描画ウィジェット
 layout_central->addWidget(&ChargeDraw);
 ChargeDraw.setFocus();
}

void Charge_Window::keyPressEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X) {
  SharedPrm->KeyX = true;
  SharedPrm->KeyZ = false;
 }
 else if(event->key() == Qt::Key_Z) {
  SharedPrm->KeyX = false;
  SharedPrm->KeyZ = true;
 }
}

void Charge_Window::keyReleaseEvent(QKeyEvent *event) {
 if(event->key() == Qt::Key_X)
  SharedPrm->KeyX = false;
 else if(event->key() == Qt::Key_Z)
  SharedPrm->KeyZ = false;
}

