#include "contact_map_draw.h"
#include <QPainter>

Contact_Map_Draw::Contact_Map_Draw(const Unit *u)
 : Unit0(u),
   AtomVect(Unit0->atom_vect()),
   SerialToIdx(Unit0->serial_to_idx()),
   MolVect(Unit0->mol_vect()),
   Margin(50),
   Color{Qt::red,
        Qt::darkRed,
        Qt::yellow,
        Qt::darkYellow,
        Qt::green,
        Qt::cyan,
        Qt::darkCyan,
        Qt::blue,
        Qt::magenta,
        Qt::black}
{
 setStyleSheet("background-color:white");

 //painEvent が発生するので描画される
 recover_c_alpha_idx(0, 0);
 calc_score_0();
 calc_color();
}

void Contact_Map_Draw::paintEvent(QPaintEvent *) {
 if(ScoreMatrix.empty())
  return;

 draw_frame();
 draw_dot();
}

void Contact_Map_Draw::plot_contact_map_0(int mol, int pept) {
 recover_c_alpha_idx(mol, pept);
 calc_score_0();
 calc_color();
 repaint();
}

void Contact_Map_Draw::plot_contact_map_1(int mol, int pept) {
 recover_c_alpha_idx(mol, pept);
 calc_score_1();
 calc_color();
 repaint();
}

void Contact_Map_Draw::recover_c_alpha_idx(int mol, int pept) {
 CAIdx.clear();
 CAIdx.shrink_to_fit();

 const std::vector<Amino_Acid> *peptide = Unit0->peptide(mol, pept);
 for(const Amino_Acid &aa : *peptide) {
  int ca_serial = aa.Annot.at(CA);
  int ca_idx = SerialToIdx->at(ca_serial);
  CAIdx.push_back(ca_idx);
 }
}

void Contact_Map_Draw::calc_score_0() {
 int aa_cnt = CAIdx.size();

 setMinimumSize(aa_cnt +100, aa_cnt + 100);

 ScoreMatrix.assign(aa_cnt, std::vector<double>(aa_cnt, 0.0));

 int i_end = aa_cnt - 1;
 for(int i = 0; i < i_end; ++i) {
  const Atom &atom_i = (*AtomVect)[CAIdx[i]];
  const Eigen::Vector3d &v_i = atom_i.XYZ;
  for(int j = i + 1; j < aa_cnt; ++j) {
   const Atom &atom_j = (*AtomVect)[CAIdx[j]];
   const Eigen::Vector3d &v_j = atom_j.XYZ;
   double distance = (v_j - v_i).norm();
   ScoreMatrix[i][j] = ScoreMatrix[j][i] = distance;
  }
 }
}

void Contact_Map_Draw::calc_score_1() {
 calc_score_0();

 int aa_cnt = CAIdx.size();
 int i_end = aa_cnt -1;
 for(int i = 1; i < i_end; ++i)
  for(int j = i + 1; j < aa_cnt; ++j) {
   double val = ScoreMatrix[j][i];


   ScoreMatrix[i][j] = ScoreMatrix[j][i] = val;
  }
}

void Contact_Map_Draw::calc_color() {
 ColorMatrix.clear();
 ColorMatrix.shrink_to_fit();

 int aa_cnt = CAIdx.size();
 ColorMatrix.assign(aa_cnt,
        std::vector<QColor>(aa_cnt, Qt::black));

 int i_end = aa_cnt - 1;
 double min = 100.0;
 double max = 0.0;
 for(int i = 0; i < i_end; ++i)
  for(int j = i + 1; j < aa_cnt; ++j) {
   if(max < ScoreMatrix[i][j])
    max = ScoreMatrix[i][j];
   if(min > ScoreMatrix[i][j])
    min = ScoreMatrix[i][j];
  }

 //level[0] は min を格納する
 std::array<double, 10> level;
 double range = (max - min) / 10.0;
 for(int i = 0; i < 10; ++i)
  level[i] = min + range * (double)(i);

 for(int i = 0; i < aa_cnt; ++i)
  for(int j = i; j < aa_cnt; ++j) {
   if(ScoreMatrix[i][j] > level[9])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[9];
   else if(ScoreMatrix[i][j] > level[8])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[8];
   else if(ScoreMatrix[i][j] > level[7])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[7];
   else if(ScoreMatrix[i][j] > level[6])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[6];
   else if(ScoreMatrix[i][j] > level[5])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[5];
   else if(ScoreMatrix[i][j] > level[4])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[4];
   else if(ScoreMatrix[i][j] > level[3])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[3];
   else if(ScoreMatrix[i][j] > level[2])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[2];
   else if(ScoreMatrix[i][j] > level[1])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[1];
   else  //if(ScoreMatrix[i][j] > level[0])
    ColorMatrix[i][j] = ColorMatrix[j][i] = Color[0];
  }
}

void Contact_Map_Draw::draw_dot() {
 QPainter painter(this);
 int aa_cnt = ScoreMatrix.size();
 int y_pos = 0;
 for(int i = 0; i < aa_cnt; ++i) {
  y_pos = i + Margin;
  for(int j = 0; j < aa_cnt; ++j) {
   painter.setPen(Qt::white);
   painter.drawPoint(j + Margin, y_pos);
   painter.setPen(ColorMatrix[j][i]);
   painter.drawPoint(j + Margin, y_pos);
  }
 }
}

void Contact_Map_Draw::draw_frame() {
 QPainter painter(this);

 int size = CAIdx.size();

 //枠
 painter.drawRect(Margin, Margin, size, size);

 //目盛
 int scale = 100;
 int scale_cnt = size / scale;  //100 ドットごとに目盛を打つ
 for(int i = 1; i <= scale_cnt; ++i) {
  //上側の横軸の目盛り
  painter.drawLine(Margin + scale * i, Margin,
         Margin + scale * i, Margin - 10);
  //下側の横軸の目盛り
  painter.drawLine(Margin + scale * i, Margin + size,
        Margin + scale * i, Margin + size + 10);
  //左側の縦軸の目盛り
  painter.drawLine(Margin, Margin + scale * i,
        Margin - 10, Margin + scale * i);
  painter.drawLine(Margin + size, Margin + scale * i,
        Margin + size + 10, Margin + scale * i);
 }
}

