#ifndef ___CONTACT_MAP_DRAW_H
#define ___CONTACT_MAP_DRAW_H

#include <builcule/unit.h>
#include <QWidget>

class Contact_Map_Draw : public QWidget {
 private:
  const Unit *Unit0;
  const std::vector<Atom> *AtomVect;
  const std::map<int, int> *SerialToIdx;
  const std::vector<Mol> *MolVect;

  std::vector<int> CAIdx;

  int Margin;
  std::array<QColor, 10> Color;
  std::vector<std::vector<double>> ScoreMatrix;
  std::vector<std::vector<QColor>> ColorMatrix;

  void paintEvent(QPaintEvent *) override;

  void recover_c_alpha_idx(int mol, int pept);
  void calc_score_0();
  void calc_score_1();
  void calc_color();
  void draw_frame();
  void draw_dot();

 public:
  Contact_Map_Draw(const Unit *u);
  void plot_contact_map_0(int mol, int pept);
  void plot_contact_map_1(int mol, int pept);
};

#endif

